/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation.rest;

import com.googlecode.androidannotations.annotations.rest.Post;
import com.googlecode.androidannotations.helper.RestAnnotationHelper;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class PostValidator
implements ElementValidator {
    private ValidatorHelper validatorHelper;
    private RestAnnotationHelper restAnnotationHelper;

    public PostValidator(ProcessingEnvironment processingEnv) {
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
        this.restAnnotationHelper = new RestAnnotationHelper(processingEnv, this.getTarget());
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Post.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.notAlreadyValidated(element, validatedElements, valid);
        this.validatorHelper.enclosingElementHasRestAnnotation(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.throwsOnlyRestClientException(executableElement, valid);
        this.validatorHelper.doesNotReturnPrimitive(executableElement, valid);
        this.validatorHelper.returnTypeNotGenericUnlessResponseEntity(executableElement, valid);
        this.restAnnotationHelper.urlVariableNamesExistInParametersAndHasOnlyOneMoreParameter(executableElement, valid);
        return valid.isValid();
    }
}

