/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.CholeskyDecomposition;
import org.ejml.alg.dense.decomposition.DecompositionInterface;
import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.alg.dense.decomposition.LUDecomposition;
import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.alg.dense.decomposition.SingularValueDecomposition;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL;
import org.ejml.alg.dense.decomposition.eig.SwitchingEigenDecomposition;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionBlock;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionHouseholder;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrDecompose;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.ops.EigenOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleMatrix;

public class DecompositionFactory {
    public static CholeskyDecomposition<DenseMatrix64F> chol(int widthWidth, boolean lower) {
        if (widthWidth < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            return new CholeskyDecompositionInner(lower);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new CholeskyDecompositionBlock64(lower);
        }
        return new CholeskyDecompositionBlock(EjmlParameters.BLOCK_WIDTH_CHOL);
    }

    public static CholeskyDecompositionLDL cholLDL(int matrixWidth) {
        return new CholeskyDecompositionLDL();
    }

    public static LUDecomposition<DenseMatrix64F> lu(int matrixWidth) {
        return new LUDecompositionAlt();
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int numRows, int numCols) {
        return new SvdImplicitQrDecompose(false, true, true);
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int numRows, int numCols, boolean needU, boolean needV, boolean compact) {
        return new SvdImplicitQrDecompose(compact, needU, needV);
    }

    public static QRDecomposition<DenseMatrix64F> qr(int numRows, int numCols) {
        return new QRDecompositionHouseholderColumn();
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixWidth) {
        return new SwitchingEigenDecomposition(matrixWidth);
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixWidth, boolean needVectors) {
        return new SwitchingEigenDecomposition(matrixWidth, needVectors, 1.0E-8);
    }

    public static double quality(DenseMatrix64F orig, SingularValueDecomposition<DenseMatrix64F> svd) {
        return DecompositionFactory.quality(orig, svd.getU(false), svd.getW(null), svd.getV(true));
    }

    public static double quality(DenseMatrix64F orig, DenseMatrix64F U, DenseMatrix64F W, DenseMatrix64F Vt) {
        SimpleMatrix _U = SimpleMatrix.wrap(U);
        SimpleMatrix _W = SimpleMatrix.wrap(W);
        SimpleMatrix _Vt = SimpleMatrix.wrap(Vt);
        SimpleMatrix foundA = _U.mult(_W).mult(_Vt);
        return SpecializedOps.diffNormF(orig, foundA.getMatrix()) / foundA.normF();
    }

    public static double quality(DenseMatrix64F orig, EigenDecomposition<DenseMatrix64F> eig) {
        SimpleMatrix A = SimpleMatrix.wrap(orig);
        SimpleMatrix V = SimpleMatrix.wrap(EigenOps.createMatrixV(eig));
        SimpleMatrix D = SimpleMatrix.wrap(EigenOps.createMatrixD(eig));
        SimpleMatrix L = A.mult(V);
        SimpleMatrix R = V.mult(D);
        SimpleMatrix diff = L.minus(R);
        double top = diff.normF();
        double bottom = L.normF();
        double error = top / bottom;
        return error;
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal() {
        return new TridiagonalDecompositionHouseholder();
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal(TridiagonalSimilarDecomposition<DenseMatrix64F> decomp, int matrixWidth) {
        if (decomp == null) {
            if (matrixWidth >= 1800) {
                return new TridiagonalDecompositionBlock();
            }
            return new TridiagonalDecompositionHouseholder();
        }
        if (matrixWidth >= 1800) {
            if (!(decomp instanceof TridiagonalDecompositionBlock)) {
                return new TridiagonalDecompositionBlock();
            }
        } else if (!(decomp instanceof TridiagonalDecompositionHouseholder)) {
            return new TridiagonalDecompositionHouseholder();
        }
        return decomp;
    }

    public static <T extends Matrix64F> boolean decomposeSafe(DecompositionInterface<T> decomp, T M) {
        if (decomp.inputModified()) {
            return decomp.decompose(M.copy());
        }
        return decomp.decompose(M);
    }
}

