/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SolvePseudoInverse
implements LinearSolver<DenseMatrix64F> {
    private LinearSolver<DenseMatrix64F> inverter;
    private DenseMatrix64F ATA;
    private DenseMatrix64F pinv;
    private int maxRows = -1;
    private int maxCols = -1;

    public SolvePseudoInverse(LinearSolver<DenseMatrix64F> inverter) {
        this.inverter = inverter.modifiesA() ? new LinearSolverSafe<DenseMatrix64F>(inverter) : inverter;
    }

    public SolvePseudoInverse(int maxCols) {
        this(new LinearSolverChol((CholeskyDecompositionCommon)DecompositionFactory.chol(maxCols, true)));
    }

    public SolvePseudoInverse() {
        this(new LinearSolverChol((CholeskyDecompositionCommon)DecompositionFactory.chol(0, true)));
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.ATA = new DenseMatrix64F(maxCols, maxCols);
        this.pinv = new DenseMatrix64F(maxCols, maxRows);
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this.ATA.reshape(A.numCols, A.numCols, false);
        CommonOps.multTransA(A, A, this.ATA);
        if (!this.inverter.setA(this.ATA)) {
            return false;
        }
        this.inverter.invert(this.ATA);
        CommonOps.multTransB(this.ATA, A, this.pinv);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void solve(DenseMatrix64F b, DenseMatrix64F x) {
        CommonOps.mult(this.pinv, b, x);
    }

    @Override
    public void invert(DenseMatrix64F A_inv) {
        A_inv.set(this.pinv);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

