/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouseCol
extends LinearSolverAbstract {
    private QRDecompositionHouseholderColumn decomposer = new QRDecompositionHouseholderColumn();
    private double[] a;
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private DenseMatrix64F R;
    private double[] gammas;

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.a = new double[maxRows];
        this.R = new DenseMatrix64F(maxCols, maxCols);
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this._setA(A);
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(true, this.R);
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + X.numRows + " expected = " + this.numCols);
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.a[i] = B.data[i * BnumCols + colB];
            }
            for (int n = 0; n < this.numCols; ++n) {
                int i2;
                double[] u = this.QR[n];
                double ub = this.a[n];
                for (i2 = n + 1; i2 < this.numRows; ++i2) {
                    ub += u[i2] * this.a[i2];
                }
                int n2 = n;
                this.a[n2] = this.a[n2] - (ub *= this.gammas[n]);
                for (i2 = n + 1; i2 < this.numRows; ++i2) {
                    int n3 = i2;
                    this.a[n3] = this.a[n3] - u[i2] * ub;
                }
            }
            TriangularSolver.solveU(this.R.data, this.a, this.numCols);
            for (i = 0; i < this.numCols; ++i) {
                X.data[i * X.numCols + colB] = this.a[i];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

