/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.ops.MatrixComponent;

public class MatrixIO {
    public static void show(D1Matrix64F A, String title) {
        JFrame frame = new JFrame(title);
        int width = 300;
        int height = 300;
        if (A.numRows > A.numCols) {
            width = width * A.numCols / A.numRows;
        } else {
            height = height * A.numRows / A.numCols;
        }
        MatrixComponent panel = new MatrixComponent(width, height);
        panel.setMatrix(A);
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Matrix64F A, String fileName) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(fileName);
        ObjectOutputStream stream = new ObjectOutputStream(fileStream);
        try {
            stream.writeObject(A);
            stream.flush();
        }
        finally {
            try {
                stream.close();
            }
            finally {
                fileStream.close();
            }
        }
    }

    public static <T extends Matrix64F> T load(String fileName) throws IOException {
        Matrix64F ret;
        FileInputStream fileStream = new FileInputStream(fileName);
        ObjectInputStream stream = new ObjectInputStream(fileStream);
        try {
            ret = (Matrix64F)stream.readObject();
            if (stream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        stream.close();
        return (T)ret;
    }

    public static void print(PrintStream out, Matrix64F mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, Matrix64F mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f ";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, Matrix64F mat, String format) {
        out.println("Type = dense , numRows = " + mat.numRows + " , numCols = " + mat.numCols);
        format = format + " ";
        for (int y = 0; y < mat.numRows; ++y) {
            for (int x = 0; x < mat.numCols; ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, Matrix64F mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = format + " ";
        for (int y = row0; y < row1; ++y) {
            for (int x = col0; x < col1; ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }
}

