/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.factory;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL;
import org.ejml.alg.dense.decomposition.eig.SwitchingEigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.SymmetricQRAlgorithmDecomposition;
import org.ejml.alg.dense.decomposition.eig.WatchedDoubleStepQRDecomposition;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionBlock;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionHouseholder;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrDecompose;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.ReshapeMatrix64F;
import org.ejml.factory.CholeskyDecomposition;
import org.ejml.factory.DecompositionInterface;
import org.ejml.factory.EigenDecomposition;
import org.ejml.factory.LUDecomposition;
import org.ejml.factory.QRDecomposition;
import org.ejml.factory.QRPDecomposition;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.EigenOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleMatrix;

public class DecompositionFactory {
    public static CholeskyDecomposition<DenseMatrix64F> chol(int matrixSize, boolean lower) {
        if (matrixSize < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            return new CholeskyDecompositionInner(lower);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new CholeskyDecompositionBlock64(lower);
        }
        return new CholeskyDecompositionBlock(EjmlParameters.BLOCK_WIDTH_CHOL);
    }

    public static CholeskyDecompositionLDL cholLDL(int matrixSize) {
        return new CholeskyDecompositionLDL();
    }

    public static LUDecomposition<DenseMatrix64F> lu(int numRows, int numCol) {
        return new LUDecompositionAlt();
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int numRows, int numCols, boolean needU, boolean needV, boolean compact) {
        return new SvdImplicitQrDecompose(compact, needU, needV, false);
    }

    public static QRDecomposition<DenseMatrix64F> qr(int numRows, int numCols) {
        return new QRDecompositionHouseholderColumn();
    }

    public static QRPDecomposition<DenseMatrix64F> qrp(int numRows, int numCols) {
        return new QRColPivDecompositionHouseholderColumn();
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixSize, boolean needVectors) {
        return new SwitchingEigenDecomposition(matrixSize, needVectors, 1.0E-8);
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int matrixSize, boolean computeVectors, boolean isSymmetric) {
        if (isSymmetric) {
            TridiagonalSimilarDecomposition<DenseMatrix64F> decomp = DecompositionFactory.tridiagonal(matrixSize);
            return new SymmetricQRAlgorithmDecomposition(decomp, computeVectors);
        }
        return new WatchedDoubleStepQRDecomposition(computeVectors);
    }

    public static double quality(DenseMatrix64F orig, SingularValueDecomposition<DenseMatrix64F> svd) {
        return DecompositionFactory.quality(orig, svd.getU(null, false), svd.getW(null), svd.getV(null, true));
    }

    public static double quality(DenseMatrix64F orig, DenseMatrix64F U, DenseMatrix64F W, DenseMatrix64F Vt) {
        SimpleMatrix _U = SimpleMatrix.wrap(U);
        SimpleMatrix _W = SimpleMatrix.wrap(W);
        SimpleMatrix _Vt = SimpleMatrix.wrap(Vt);
        SimpleMatrix foundA = _U.mult(_W).mult(_Vt);
        return SpecializedOps.diffNormF(orig, foundA.getMatrix()) / foundA.normF();
    }

    public static double quality(DenseMatrix64F orig, EigenDecomposition<DenseMatrix64F> eig) {
        SimpleMatrix A = SimpleMatrix.wrap(orig);
        SimpleMatrix V = SimpleMatrix.wrap(EigenOps.createMatrixV(eig));
        SimpleMatrix D = SimpleMatrix.wrap(EigenOps.createMatrixD(eig));
        SimpleMatrix L = A.mult(V);
        SimpleMatrix R = V.mult(D);
        SimpleMatrix diff = L.minus(R);
        double top = diff.normF();
        double bottom = L.normF();
        double error = top / bottom;
        return error;
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal(int matrixSize) {
        if (matrixSize >= 1800) {
            return new TridiagonalDecompositionBlock();
        }
        return new TridiagonalDecompositionHouseholder();
    }

    public static <T extends ReshapeMatrix64F> boolean decomposeSafe(DecompositionInterface<T> decomp, T M) {
        if (decomp.inputModified()) {
            return decomp.decompose(M.copy());
        }
        return decomp.decompose(M);
    }
}

