/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.core;

import com.googlecode.googleplus.core.OAuth2RefreshCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenRefreshingClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(TokenRefreshingClientHttpRequestFactory.class);
    private ClientHttpRequestFactory delegate;
    private OAuth2RefreshCallback callback;
    private List<ClientHttpRequestInterceptor> requestInterceptors;

    public TokenRefreshingClientHttpRequestFactory(ClientHttpRequestFactory requestFactory, OAuth2RefreshCallback callback, List<ClientHttpRequestInterceptor> requestInterceptors) {
        this.delegate = requestFactory;
        this.callback = callback;
        this.requestInterceptors = requestInterceptors;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        ClientHttpRequest request = this.delegate.createRequest(uri, httpMethod);
        return new TokenRefreshingClientHttpRequest(request);
    }

    private final class TokenRefreshingClientHttpRequest
    implements ClientHttpRequest {
        private ClientHttpRequest delegate;

        public TokenRefreshingClientHttpRequest(ClientHttpRequest delegate) {
            this.delegate = delegate;
        }

        public HttpMethod getMethod() {
            return this.delegate.getMethod();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            return this.delegate.getBody();
        }

        public ClientHttpResponse execute() throws IOException {
            ClientHttpResponse response = this.delegate.execute();
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                logger.info("Token is invalid (got 401 response). Trying get a new token using the refresh token");
                String newToken = TokenRefreshingClientHttpRequestFactory.this.callback.refreshToken();
                if (newToken == null) {
                    return response;
                }
                logger.info("New token obtained, retrying the request with it");
                for (ClientHttpRequestInterceptor interceptor : TokenRefreshingClientHttpRequestFactory.this.requestInterceptors) {
                    if (!interceptor.getClass().getName().equals("org.springframework.social.oauth2.OAuth2RequestInterceptor")) continue;
                    Field field = ReflectionUtils.findField(interceptor.getClass(), (String)"accessToken");
                    field.setAccessible(true);
                    ReflectionUtils.setField((Field)field, (Object)interceptor, (Object)newToken);
                }
                ClientHttpRequest newRequest = TokenRefreshingClientHttpRequestFactory.this.delegate.createRequest(this.delegate.getURI(), this.delegate.getMethod());
                return newRequest.execute();
            }
            return response;
        }
    }
}

