/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitCounter;
import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.RunningLengthWord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EWAHCompressedBitmap
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage,
LogicalElement<EWAHCompressedBitmap> {
    int actualsizeinwords = 1;
    long[] buffer = null;
    RunningLengthWord rlw = null;
    int sizeinbits = 0;
    static final int defaultbuffersize = 4;
    public static final boolean usetrailingzeros = true;
    public static final int wordinbits = 64;

    public EWAHCompressedBitmap() {
        this.buffer = new long[4];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    public EWAHCompressedBitmap(int buffersize) {
        this.buffer = new long[buffersize];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    @Override
    public void add(long newdata) {
        this.add(newdata, 64);
    }

    public void add(long newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0L) {
            this.addEmptyWord(false);
        } else if (newdata == -1L) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    private void addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        long runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runlen + 1L);
            return;
        }
        this.push_back(0L);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    private void addLiteralWord(long newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Integer.MAX_VALUE) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.push_back(newdata);
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
    }

    @Override
    public void addStreamOfLiteralWords(long[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 64;
        if (leftovernumber > 0) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfLiteralWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeinbits = (int)((long)this.sizeinbits + number * 64L);
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(long[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.negative_push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 64;
        if (leftovernumber > 0) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfLiteralWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public EWAHCompressedBitmap and(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.and(a, container);
        return container;
    }

    private void and(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.and(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNot(a, container);
        return container;
    }

    private void andNot(EWAHCompressedBitmap a, BitmapStorage container) {
        IteratingBufferedRunningLengthWord remaining;
        EWAHIterator i = this.getEWAHIterator();
        EWAHIterator j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & (rlwj.getLiteralWordAt(k) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andNot(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter = (int)((long)counter + 64L * localrlw.getRunningLength());
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Long.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0L;
    }

    public Object clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap clone = (EWAHCompressedBitmap)super.clone();
        clone.buffer = (long[])this.buffer.clone();
        clone.rlw = new RunningLengthWord(clone.buffer, this.rlw.position);
        clone.actualsizeinwords = this.actualsizeinwords;
        clone.sizeinbits = this.sizeinbits;
        return clone;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new long[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readLong();
        }
        this.rlw = new RunningLengthWord(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            try {
                this.xor((EWAHCompressedBitmap)o, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    protected EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer, this.actualsizeinwords);
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        v.add(new Integer(pos++));
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 64;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() >>> 32)));
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] >>> 32)));
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap a) {
        NonEmptyVirtualStorage nevs = new NonEmptyVirtualStorage();
        try {
            this.and(a, nevs);
        }
        catch (NonEmptyVirtualStorage.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(new EWAHIterator(this.buffer, this.actualsizeinwords));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(long[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualsizeinwords + k] = data[start + k] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualsizeinwords += number;
    }

    @Override
    public void not() {
        RunningLengthWord rlw1;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = i.buffer()[i.literalWords() + j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } while (i.hasNext());
        if (rlw1.getNumberOfLiteralWords() == 0) {
            return;
        }
        int usedbitsinlast = this.sizeinbits % 64;
        if (usedbitsinlast == 0) {
            return;
        }
        long[] lArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        lArray[n] = lArray[n] & -1L >>> 64 - usedbitsinlast;
    }

    public EWAHCompressedBitmap or(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.or(a, container);
        return container;
    }

    private void or(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.or(a, counter);
        return counter.getCount();
    }

    private void push_back(long data) {
        if (this.actualsizeinwords == this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(long[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualsizeinwords, number);
        this.actualsizeinwords += number;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[size];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeLong(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFBF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483583");
        }
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 64) / 64 - (this.sizeinbits + 64 - 1) / 64;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1L << i % 64;
        if (this.buffer[this.actualsizeinwords - 1] == -1L) {
            this.buffer[this.actualsizeinwords - 1] = 0L;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void setSizeInBits(int size) {
        this.sizeinbits = size;
    }

    public boolean setSizeInBits(int size, boolean defaultvalue) {
        if (size < this.sizeinbits) {
            return false;
        }
        if (defaultvalue) {
            while (this.sizeinbits % 64 != 0 && this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap.extendEmptyBits(this, this.sizeinbits, size);
        } else {
            int leftover = size % 64;
            this.addStreamOfEmptyWords(defaultvalue, size / 64 - this.sizeinbits / 64);
            long newdata = (1L << leftover) - 1L;
            this.addLiteralWord(newdata);
        }
        this.sizeinbits = size;
        return true;
    }

    @Override
    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualsizeinwords * 8;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        ans[inanspos++] = pos++;
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 64;
            }
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                long data = i.buffer()[i.literalWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public String toString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
        }
        return ans;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xor(a, container);
        return container;
    }

    private void xor(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.xor(a, counter);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void and(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].and(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeinbits < b.sizeinbits ? -1 : (a.sizeinbits == b.sizeinbits ? 0 : 1);
            }
        });
        maxSize = sortedBitmaps[sortedBitmaps.length - 1].sizeinbits;
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        for (i = 0; i < sortedBitmaps.length; ++i) {
            iterator = sortedBitmaps[i].getEWAHIterator();
            if (!iterator.hasNext()) {
                if (maxSize > 0) {
                    EWAHCompressedBitmap.extendEmptyBits(container, 0, maxSize);
                }
                container.setSizeInBits(maxSize);
                return;
            }
            rlws[i] = new IteratingBufferedRunningLengthWord(iterator);
        }
        block1: while (true) {
            maxZeroRl = 0L;
            minOneRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            if (rlws[0].size() == 0L) break;
            for (IteratingBufferedRunningLengthWord rlw : rlws) {
                size = rlw.size();
                minSize = Math.min(minSize, size);
                if (!rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxZeroRl = Math.max(maxZeroRl, rl);
                    minOneRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minOneRl = Math.min(minOneRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, maxZeroRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(maxZeroRl);
                    ++i$;
                }
            }
            if (minOneRl > 0L) {
                container.addStreamOfEmptyWords(true, minOneRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(minOneRl);
                    ++i$;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (IteratingBufferedRunningLengthWord rlw : rlws) {
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!EWAHCompressedBitmap.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = -1L;
                for (IteratingBufferedRunningLengthWord rlw : rlws) {
                    if (rlw.getRunningLength() > (long)index) continue;
                    word &= rlw.getLiteralWordAt(index - (int)rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            arr$ = rlws;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ >= len$) ** break;
                rlw = arr$[i$];
                rlw.discardFirstWords(minSize);
                ++i$;
            }
            break;
        }
        EWAHCompressedBitmap.extendEmptyBits(container, sortedBitmaps[0].sizeinbits, maxSize);
        container.setSizeInBits(maxSize);
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.and((BitmapStorage)container, bitmaps);
        return container;
    }

    public static int andCardinality(EWAHCompressedBitmap ... bitmaps) {
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.and(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap bitmapOf(int ... setbits) {
        EWAHCompressedBitmap a = new EWAHCompressedBitmap();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    private static void extendEmptyBits(BitmapStorage storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 64;
        int finalLeftover = newSize % 64;
        storage.addStreamOfEmptyWords(false, newSize / 64 - currentSize / 64 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    /*
     * Unable to fully structure code
     */
    private static void or(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].or(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0L;
            minZeroRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0L) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0L) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!EWAHCompressedBitmap.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = 0L;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > (long)index) continue;
                    word |= rlw.getLiteralWordAt(index - (int)rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.or((BitmapStorage)container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap ... bitmaps) {
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.or(counter, bitmaps);
        return counter.getCount();
    }
}

