/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.RunningLengthWord32;

public final class EWAHIterator32
implements Cloneable {
    int pointer;
    RunningLengthWord32 rlw;
    int size;

    public EWAHIterator32(EWAHCompressedBitmap32 a, int sizeInWords) {
        this.rlw = new RunningLengthWord32(a, 0);
        this.size = sizeInWords;
        this.pointer = 0;
    }

    public static EWAHIterator32 getEWAHIterator(EWAHCompressedBitmap32 bitmap) {
        return bitmap.getEWAHIterator();
    }

    public int[] buffer() {
        return this.rlw.parent.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord32 next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator32 clone() throws CloneNotSupportedException {
        EWAHIterator32 ans = (EWAHIterator32)super.clone();
        ans.rlw = this.rlw.clone();
        ans.size = this.size;
        ans.pointer = this.pointer;
        return ans;
    }
}

