package com.googlecode.jpattern.shared.result;


/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public class ErrorMessage implements  IErrorMessage {

    private static final long serialVersionUID = 1L;

    private String propertyName;
    
    private String propertyMessage;

    private String[] parameters;
    
    public ErrorMessage(String propertyName, String propertyMessage) {
    	this(propertyName, propertyMessage, null);
    }    
    
    public ErrorMessage(String propertyName, String propertyMessage, String[] parameters) {
    	this.propertyMessage = propertyMessage;
    	this.propertyName = propertyName;
    	this.parameters = parameters;
    }

    public String getMessage() {
        return propertyMessage;
    }

    public String getName() {
        return propertyName;
    }
    
    public String[] getParameters() {
        if (parameters==null) {
            parameters = new String[0];
        }
        return parameters;
    }    
}
