/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.castor.core.util.Base64Encoder;
import org.redmine.ta.AuthenticationException;
import org.redmine.ta.NotFoundException;
import org.redmine.ta.RedmineException;
import org.redmine.ta.internal.HttpUtil;
import org.redmine.ta.internal.RedmineXMLParser;
import org.redmine.ta.internal.logging.Logger;
import org.redmine.ta.internal.logging.LoggerFactory;

public class Communicator {
    public static final String CHARSET = "UTF-8";
    private Logger logger = LoggerFactory.getLogger(Communicator.class);
    private String login;
    private String password;

    public String sendRequest(HttpRequest request) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.logger.debug(request.getRequestLine().toString());
        DefaultHttpClient httpclient = HttpUtil.getNewHttpClient();
        this.configureProxy(httpclient);
        if (this.login != null) {
            String credentials = String.valueOf(Base64Encoder.encode((byte[])(this.login + ':' + this.password).getBytes(CHARSET)));
            request.addHeader("Authorization", "Basic: " + credentials);
        }
        request.addHeader("Accept-Encoding", "gzip,deflate");
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)request);
        int responseCode = httpResponse.getStatusLine().getStatusCode();
        if (responseCode == 401) {
            throw new AuthenticationException("Authorization error. Please check if you provided a valid API access key or Login and Password and REST API service is enabled on the server.");
        }
        if (responseCode == 403) {
            throw new AuthenticationException("Forbidden. Please check the user has proper permissions.");
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)responseEntity);
        if (responseCode == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + responseBody);
        }
        if (responseCode == 422) {
            List<String> errors = RedmineXMLParser.parseErrors(responseBody);
            throw new RedmineException(errors);
        }
        httpclient.getConnectionManager().shutdown();
        return responseBody;
    }

    private void configureProxy(DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port = Integer.parseInt(proxyPort);
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public String sendGet(URI uri) throws NotFoundException, IOException, AuthenticationException, RedmineException {
        HttpGet http = new HttpGet(uri);
        return this.sendRequest((HttpRequest)http);
    }
}

