/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.redmine.ta.beans.Attachment;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueCategory;
import org.redmine.ta.beans.IssueStatus;
import org.redmine.ta.beans.News;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.SavedQuery;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.Tracker;
import org.redmine.ta.beans.User;
import org.redmine.ta.beans.Version;

public class URIConfigurator {
    private static final String XML_URL_POSTFIX = ".xml";
    private static final Map<Class, String> urls = new HashMap<Class, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(User.class, "users");
            this.put(Issue.class, "issues");
            this.put(Project.class, "projects");
            this.put(TimeEntry.class, "time_entries");
            this.put(SavedQuery.class, "queries");
            this.put(IssueStatus.class, "issue_statuses");
            this.put(Version.class, "versions");
            this.put(IssueCategory.class, "issue_categories");
            this.put(Tracker.class, "trackers");
            this.put(Attachment.class, "attachments");
            this.put(News.class, "news");
        }
    };
    private final String host;
    private String apiAccessKey;

    public URIConfigurator(String host) {
        this.host = host;
    }

    public URI createURI(String query) {
        return this.createURI(query, new ArrayList<NameValuePair>());
    }

    public URI createURI(String query, NameValuePair ... param) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        for (NameValuePair p : param) {
            list.add(p);
        }
        return this.createURI(query, list);
    }

    public URI createURI(String query, List<NameValuePair> params) {
        URI uri;
        if (this.apiAccessKey != null) {
            params.add((NameValuePair)new BasicNameValuePair("key", this.apiAccessKey));
        }
        try {
            URL url = new URL(this.host);
            String path = url.getPath();
            if (!query.isEmpty()) {
                path = path + "/" + query;
            }
            uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)path, (String)URLEncodedUtils.format(params, (String)"UTF-8"), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public URI getCreateURI(Class zz) throws MalformedURLException {
        String query = urls.get(zz) + XML_URL_POSTFIX;
        return this.createURI(query);
    }

    public URI getUpdateURI(Class zz, String id) {
        String query = urls.get(zz) + "/" + id + XML_URL_POSTFIX;
        return this.createURI(query);
    }

    public URI getUpdateURI(Class zz, String id, NameValuePair ... param) {
        String query = urls.get(zz) + "/" + id + XML_URL_POSTFIX;
        return this.createURI(query, param);
    }

    public URI getCreateURIIssueCategory(Integer projectID) {
        return this.createURI("projects/" + projectID + "/issue_categories.xml");
    }

    public void setApiAccessKey(String apiAccessKey) {
        this.apiAccessKey = apiAccessKey;
    }

    public URI getRetrieveObjectsListURI(Class className, List<NameValuePair> param) {
        String query = urls.get(className) + XML_URL_POSTFIX;
        return this.createURI(query, param);
    }

    public URI getRetrieveObjectURI(Class className, Integer id, List<NameValuePair> param) {
        String query = urls.get(className) + "/" + id + XML_URL_POSTFIX;
        return this.createURI(query, param);
    }
}

