/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ssdutils.jlauncher;

import com.googlecode.ssdutils.jlauncher.LaunchConfiguration;
import com.googlecode.ssdutils.jlauncher.annotations.Launcher;
import com.googlecode.ssdutils.jlauncher.annotations.Option;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsReader {
    protected static final String LAUNCHER_ANNOTATION = Launcher.class.getName();

    protected Class<?> getClassByName(String className) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(className);
    }

    public Set<String> getLauncherClasses() throws IOException {
        URL[] urls = ClasspathUrlFinder.findClassPaths();
        AnnotationDB annotationDB = new AnnotationDB();
        annotationDB.scanArchives(urls);
        Map annotationIndex = annotationDB.getAnnotationIndex();
        return (Set)annotationIndex.get(LAUNCHER_ANNOTATION);
    }

    public Set<Field> getOptions(Class<?> launcherClazz) {
        HashSet<Field> options = new HashSet<Field>();
        for (Field f : launcherClazz.getDeclaredFields()) {
            Option o = f.getAnnotation(Option.class);
            if (o == null) continue;
            options.add(f);
        }
        return options;
    }

    public Set<Method> getLauncherMethods(Class<?> launcherClazz) {
        HashSet<Method> launchers = new HashSet<Method>();
        for (Method m : launcherClazz.getDeclaredMethods()) {
            Launcher l = m.getAnnotation(Launcher.class);
            if (l == null) continue;
            launchers.add(m);
        }
        return launchers;
    }

    public Set<LaunchConfiguration> getLaunchConfiguration() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        HashSet<LaunchConfiguration> configs = new HashSet<LaunchConfiguration>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (String runnerClasse : this.getLauncherClasses()) {
            LaunchConfiguration config = new LaunchConfiguration();
            Class<?> clazz = cl.loadClass(runnerClasse);
            config.setRunner(clazz);
            config.setLaunchers(this.getLauncherMethods(clazz));
            config.setOptions(this.getOptions(clazz));
            configs.add(config);
        }
        return configs;
    }
}

