/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ssdutils.jlauncher;

import com.googlecode.ssdutils.jlauncher.AnnotationsReader;
import com.googlecode.ssdutils.jlauncher.LaunchConfiguration;
import com.googlecode.ssdutils.jlauncher.OptionsFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JLauncher {
    private static final String COMMAND_LABEL = "command";
    private static final String HELP_LABEL = "help";
    OptionsFactory optionBuilder = new OptionsFactory();
    AnnotationsReader ar = new AnnotationsReader();

    public static void main(String[] args) throws ParseException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        new JLauncher().launch(args);
    }

    protected void launch(String[] args) throws ParseException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Options options = new Options();
        OptionBuilder.withArgName((String)COMMAND_LABEL);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"command to be launched");
        options.addOption(OptionBuilder.create((String)COMMAND_LABEL));
        OptionBuilder.withArgName((String)HELP_LABEL);
        OptionBuilder.withDescription((String)"print this help");
        options.addOption(OptionBuilder.create((String)HELP_LABEL));
        Set<LaunchConfiguration> launchConfigurations = this.ar.getLaunchConfiguration();
        LaunchConfiguration launchConfiguration = launchConfigurations.iterator().next();
        this.optionBuilder.buildOptions(options, launchConfiguration);
        GnuParser parser = new GnuParser();
        CommandLine line = parser.parse(options, args);
        if (!line.hasOption(HELP_LABEL) && this.optionBuilder.initAndValidate(launchConfiguration, line)) {
            String cmd = "";
            if (line.hasOption(COMMAND_LABEL)) {
                cmd = line.getOptionValue(COMMAND_LABEL);
            }
            launchConfiguration.run(cmd);
        } else {
            this.printHelp(options);
        }
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("JLauncher", options);
    }
}

