/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ssdutils.jlauncher;

import com.googlecode.ssdutils.jlauncher.annotations.Launcher;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfiguration {
    protected Class<?> runner;
    protected Object runnerInstance;
    protected Set<Field> options;
    protected Set<Method> launchers;

    public Class<?> getRunner() {
        return this.runner;
    }

    public void setRunner(Class<?> runner) throws InstantiationException, IllegalAccessException {
        this.runner = runner;
        this.runnerInstance = runner.newInstance();
    }

    public Set<Field> getOptions() {
        return this.options;
    }

    public void setOptions(Set<Field> options) {
        this.options = options;
    }

    public Set<Method> getLaunchers() {
        return this.launchers;
    }

    public void setLaunchers(Set<Method> launchers) {
        this.launchers = launchers;
    }

    public void run(String command) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Method launcher : this.launchers) {
            Launcher launcherAnnotation = launcher.getAnnotation(Launcher.class);
            if (!launcherAnnotation.command().equals(command)) continue;
            launcher.invoke(this.runnerInstance, new Object[0]);
        }
    }

    public void setOptionValue(Field f, String optionValue) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        Class<?> type = f.getType();
        if (type.getName().equals("int")) {
            f.setInt(this.runnerInstance, Integer.parseInt(optionValue));
        } else if (type.getName().equals("long")) {
            f.setLong(this.runnerInstance, Long.parseLong(optionValue));
        } else if (type.getName().equals("float")) {
            f.setFloat(this.runnerInstance, Float.parseFloat(optionValue));
        } else if (type.getName().equals("double")) {
            f.setDouble(this.runnerInstance, Double.parseDouble(optionValue));
        } else if (type.getName().equals("boolean")) {
            f.setBoolean(this.runnerInstance, Boolean.parseBoolean(optionValue));
        } else if (type.getName().equals("short")) {
            f.setShort(this.runnerInstance, Short.parseShort(optionValue));
        } else if (type.getName().equals("char")) {
            f.setChar(this.runnerInstance, optionValue.charAt(0));
        } else {
            f.set(this.runnerInstance, optionValue);
        }
    }
}

