/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ssdutils.jlauncher;

import com.googlecode.ssdutils.jlauncher.LaunchConfiguration;
import com.googlecode.ssdutils.jlauncher.annotations.Option;
import java.lang.reflect.Field;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class OptionsFactory {
    public void buildOptions(Options options, LaunchConfiguration launchConfiguration) {
        for (Field optionField : launchConfiguration.getOptions()) {
            Option option = optionField.getAnnotation(Option.class);
            OptionBuilder.withArgName((String)option.name());
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)option.help());
            options.addOption(OptionBuilder.create((String)option.name()));
        }
    }

    public boolean initAndValidate(LaunchConfiguration launchConfiguration, CommandLine line) throws IllegalArgumentException, IllegalAccessException {
        boolean isValide = true;
        for (Field f : launchConfiguration.getOptions()) {
            Option option = f.getAnnotation(Option.class);
            if (line.hasOption(option.name())) {
                launchConfiguration.setOptionValue(f, line.getOptionValue(option.name()));
                continue;
            }
            if (option.optional()) continue;
            isValide = false;
            break;
        }
        return isValide;
    }
}

