/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.customscalars;

import com.graphql_java_generator.customscalars.CustomScalar;
import com.graphql_java_generator.customscalars.CustomScalarRegistry;
import graphql.schema.GraphQLScalarType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CustomScalarRegistryImpl
implements CustomScalarRegistry {
    @Autowired
    ApplicationContext ctx;
    private static Map<String, CustomScalarRegistry> customScalarRegistries = new HashMap<String, CustomScalarRegistry>();
    Map<String, CustomScalar> customScalarTypes = new HashMap<String, CustomScalar>();

    public void registerGraphQLScalarType(String typeName, GraphQLScalarType type, Class<?> valueClazz) {
        this.customScalarTypes.put(typeName, new CustomScalar(GraphQLScalarType.newScalar((GraphQLScalarType)type).name(typeName).build(), valueClazz));
    }

    public GraphQLScalarType getGraphQLCustomScalarType(String graphQLTypeName) {
        CustomScalar scalar = this.customScalarTypes.get(graphQLTypeName);
        return scalar == null ? null : scalar.getGraphQLScalarType();
    }

    public CustomScalar getCustomScalar(String graphQLTypeName) {
        return this.customScalarTypes.get(graphQLTypeName);
    }

    public static boolean isCustomScalarRegistryInitialized(String schema) {
        return customScalarRegistries.get(schema) != null;
    }

    public static CustomScalarRegistry getCustomScalarRegistry(String schema) {
        CustomScalarRegistry ret = customScalarRegistries.get(schema);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown schema: The CustomScalarRegistry for the '" + schema + "' schema has not been defined");
        }
        return ret;
    }

    public static void setCustomScalarRegistry(String schema, CustomScalarRegistry customScalarRegistry) {
        customScalarRegistries.put(schema, customScalarRegistry);
    }
}

