/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.GraphQLDirective;
import com.graphql_java_generator.annotation.GraphQLEnumType;
import com.graphql_java_generator.annotation.GraphQLInterfaceType;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.GraphQLUnionType;
import com.graphql_java_generator.client.CustomScalarRegistryImpl;
import com.graphql_java_generator.client.GraphQLTypeMappingRegistry;
import com.graphql_java_generator.customscalars.CustomScalar;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class GraphqlClientUtils {
    public static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    List<Class<?>> scalars = new ArrayList();

    public GraphqlClientUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
    }

    public void checkName(String graphqlIdentifier) throws GraphQLRequestPreparationException {
        if (graphqlIdentifier == null) {
            throw new NullPointerException("A GraphQL identifier may not be null");
        }
        Matcher m = this.graphqlNamePattern.matcher(graphqlIdentifier);
        if (!m.matches()) {
            throw new GraphQLRequestPreparationException("'" + graphqlIdentifier + "' is not a valid GraphQL name");
        }
    }

    public Class<?> checkIsScalar(Field field, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(field);
        if (shouldBeScalar != null) {
            if (shouldBeScalar & !isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the GraphQL type '" + field.getDeclaringClass().getName() + "' is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
            if (shouldBeScalar == false & isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the GraphQL type '" + field.getDeclaringClass().getName() + "' is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
        }
        return this.getGraphQLType(field);
    }

    public Class<?> checkIsScalar(String fieldName, Method method, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(method);
        if (method.getReturnType() == null) {
            throw new GraphQLRequestPreparationException("There is a method of name '" + fieldName + "' in the GraphQL type '" + method.getDeclaringClass().getName() + "', but this method is a void method: it can't represent the '" + fieldName + "' GraphQL field");
        }
        if (shouldBeScalar != null) {
            if (shouldBeScalar.booleanValue() && !isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + fieldName + "' (accessed through its getter: " + method.getName() + "') of the GraphQL type '" + method.getDeclaringClass().getName() + "' should be a scalar. But is is actually not a GraphQLScalar");
            }
            if (!shouldBeScalar.booleanValue() && isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + fieldName + "' (accessed through its getter: '" + method.getName() + "') of the GraphQL type '" + method.getDeclaringClass().getName() + "' should not be a scalar. But is is actually a GraphQLScalar");
            }
        }
        return this.getGraphQLType(method);
    }

    public boolean isScalar(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null || fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class) != null;
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the class '" + field.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method '" + method.getName() + "' of the class '" + method.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> getClass(String packageName, String graphQLTypeName, String schema) {
        if ("Boolean".equals(graphQLTypeName) || "boolean".equals(graphQLTypeName)) {
            return Boolean.class;
        }
        if ("Integer".equals(graphQLTypeName) || "Int".equals(graphQLTypeName)) {
            return Integer.class;
        }
        if ("String".equals(graphQLTypeName) || "UUID".equals(graphQLTypeName)) {
            return String.class;
        }
        if ("Float".equals(graphQLTypeName) || "Double".equals(graphQLTypeName)) {
            return Double.class;
        }
        CustomScalar customScalar = CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getCustomScalar(graphQLTypeName);
        if (customScalar != null) {
            return customScalar.getValueClazz();
        }
        return GraphQLTypeMappingRegistry.getJavaClass(schema, graphQLTypeName);
    }

    public Field getDeclaredField(Class<?> owningClass, String fieldName, boolean mustFindField) throws GraphQLRequestPreparationException {
        try {
            return owningClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e1) {
            block6: {
                if (owningClass.getSimpleName().endsWith("Response")) {
                    try {
                        return owningClass.getSuperclass().getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException | SecurityException e2) {
                        if (!mustFindField) break block6;
                        throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName() + ", nor in " + owningClass.getSuperclass().getName(), e1);
                    }
                }
            }
            if (mustFindField) {
                throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName(), e1);
            }
            return null;
        }
    }

    public Class<?> getFieldType(Class<?> owningClass, String fieldName, boolean returnIsMandatory) throws GraphQLRequestPreparationException {
        if (owningClass.isInterface()) {
            try {
                Method method = owningClass.getDeclaredMethod("get" + graphqlUtils.getPascalCase(fieldName), new Class[0]);
                GraphQLNonScalar graphQLNonScalar = method.getAnnotation(GraphQLNonScalar.class);
                GraphQLScalar graphQLScalar = method.getAnnotation(GraphQLScalar.class);
                if (graphQLNonScalar != null) {
                    return graphQLNonScalar.javaClass();
                }
                if (graphQLScalar != null) {
                    return graphQLScalar.javaClass();
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the interface '" + owningClass.getName() + "': this method should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
            }
            catch (NoSuchMethodException e) {
                if (!returnIsMandatory) {
                    return null;
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
            catch (SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
        }
        try {
            Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            if (graphQLNonScalar != null) {
                return graphQLNonScalar.javaClass();
            }
            if (graphQLScalar != null) {
                return graphQLScalar.javaClass();
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "': this field should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
        }
        catch (NoSuchFieldException e) {
            if (!returnIsMandatory) {
                return null;
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
        }
        catch (SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
        }
    }

    public Class<?> getGraphQLType(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class).javaClass();
        }
        if (fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLNonScalar.class).javaClass();
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the class '" + field.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method '" + method.getName() + "' of the class '" + method.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> checkFieldOfGraphQLType(String name, Boolean shouldBeScalar, Class<?> owningClass) throws GraphQLRequestPreparationException {
        this.checkName(name);
        Class<?> fieldClass = null;
        Field field = this.getDeclaredField(owningClass, graphqlUtils.getJavaName(name), false);
        if (field != null) {
            fieldClass = this.checkIsScalar(field, shouldBeScalar);
        }
        if (fieldClass == null && !owningClass.isInterface()) {
            for (Method method : owningClass.getMethods()) {
                if (!method.getName().equals(name)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null && owningClass.isInterface()) {
            String expectedMethodName = "get" + graphqlUtils.getPascalCase(name);
            for (Method method : owningClass.getDeclaredMethods()) {
                if (!method.getName().equals(expectedMethodName)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null) {
            throw new GraphQLRequestPreparationException("The GraphQL type '" + owningClass.getSimpleName() + "' (" + owningClass.getName() + ") has no field of name '" + name + "'");
        }
        return fieldClass;
    }

    public Map<String, Object> generatesBindVariableValuesMap(Object[] paramsAndValues) throws GraphQLRequestExecutionException, ClassCastException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (paramsAndValues != null) {
            if (paramsAndValues.length % 2 != 0) {
                throw new GraphQLRequestExecutionException("An even number of parameters is expected, but " + paramsAndValues.length + " parameters where sent. This method expects a series of name and values : (paramName1, paramValue1, paramName2, paramValue2...)");
            }
            for (int i = 0; i < paramsAndValues.length; i += 2) {
                map.put((String)paramsAndValues[i], paramsAndValues[i + 1]);
            }
        }
        return map;
    }

    public String getGraphQLTypeNameFromClass(Class<?> clazz) {
        GraphQLObjectType graphQLObjectType = clazz.getAnnotation(GraphQLObjectType.class);
        if (graphQLObjectType != null) {
            return graphQLObjectType.value();
        }
        GraphQLInterfaceType graphQLInterfaceType = clazz.getAnnotation(GraphQLInterfaceType.class);
        if (graphQLInterfaceType != null) {
            return graphQLInterfaceType.value();
        }
        GraphQLUnionType graphQLUnionType = clazz.getAnnotation(GraphQLUnionType.class);
        if (graphQLUnionType != null) {
            return graphQLUnionType.value();
        }
        GraphQLEnumType graphQLEnumType = clazz.getAnnotation(GraphQLEnumType.class);
        if (graphQLEnumType != null) {
            return graphQLEnumType.value();
        }
        throw new RuntimeException("Could not find the GraphQL type for the class " + clazz.getName());
    }

    public GraphQLScalarType getGraphQLCustomScalarType(AccessibleObject fieldOrMethod, String schema) {
        String graphQLTypeName = fieldOrMethod.getAnnotation(GraphQLScalar.class) != null ? fieldOrMethod.getAnnotation(GraphQLScalar.class).graphQLTypeSimpleName() : null;
        if (graphQLTypeName != null) {
            return CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getGraphQLCustomScalarType(graphQLTypeName);
        }
        return null;
    }

    public GraphQLScalarType getGraphQLScalarTypeFromName(String typeName, String schema) {
        if (typeName.equals("String")) {
            return Scalars.GraphQLString;
        }
        if (typeName.equals("Boolean")) {
            return Scalars.GraphQLBoolean;
        }
        if (typeName.equals("Float")) {
            return Scalars.GraphQLFloat;
        }
        if (typeName.equals("Int")) {
            return Scalars.GraphQLInt;
        }
        if (typeName.equals("ID")) {
            return Scalars.GraphQLID;
        }
        return CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getGraphQLCustomScalarType(typeName);
    }

    Map<String, String> getDirectiveParameters(Object o, String parameterName, String directiveName) {
        int i;
        Parameter[] methodParameters;
        if (directiveName == null || directiveName.equals("")) {
            throw new RuntimeException("directiveName may not be null, nor an empty string");
        }
        GraphQLDirective[] directives = null;
        Parameter directive = null;
        String oName = null;
        if (parameterName != null) {
            if (!(o instanceof Method)) {
                throw new RuntimeException("parameterName is not null. It contains \"" + parameterName + "\". So o must be a Method, but it is a " + o.getClass().getName());
            }
            methodParameters = ((Method)o).getParameters();
            oName = ((Method)o).getName();
            for (i = 0; i < methodParameters.length; ++i) {
                if (!methodParameters[i].getName().equals(parameterName)) continue;
                directives = (GraphQLDirective[])methodParameters[i].getAnnotationsByType(GraphQLDirective.class);
            }
            if (directives == null) {
                throw new RuntimeException("The method " + ((Method)o).getName() + " has no parameter of name \"" + parameterName + "\"");
            }
        } else if (o instanceof Class) {
            directives = (GraphQLDirective[])((Class)o).getAnnotationsByType(GraphQLDirective.class);
            oName = ((Class)o).getName();
        } else if (o instanceof Method) {
            directives = (GraphQLDirective[])((Method)o).getAnnotationsByType(GraphQLDirective.class);
            oName = ((Method)o).getName();
        } else if (o instanceof Field) {
            directives = (GraphQLDirective[])((Field)o).getAnnotationsByType(GraphQLDirective.class);
            oName = ((Field)o).getName();
        } else {
            throw new RuntimeException("non managed object type: " + o.getClass().getName());
        }
        methodParameters = directives;
        i = methodParameters.length;
        for (int j = 0; j < i; ++j) {
            Parameter d = methodParameters[j];
            if (!directiveName.equals(d.name())) continue;
            directive = d;
        }
        if (directive == null) {
            throw new RuntimeException("No directive of name \"" + directiveName + "\" where found on the " + o.getClass().getName() + " of name \"" + oName + "\" (parameterName=" + parameterName + ")");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (directive.parameterNames() != null) {
            for (i = 0; i < directive.parameterNames().length; ++i) {
                values.put(directive.parameterNames()[i], directive.parameterValues()[i]);
            }
        }
        return values;
    }
}

