/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.GraphqlUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.request.QueryField;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Fragment {
    final String name;
    final String typeName;
    QueryField content = null;
    List<Directive> directives = new ArrayList<Directive>();

    public Fragment(QueryTokenizer qt, String packageName, boolean inlineFragment, Class<?> clazz) throws GraphQLRequestPreparationException {
        if (inlineFragment) {
            this.name = null;
            if (qt.checkNextToken("on")) {
                qt.readNextRealToken("on", "looking for the 'on' token of the fragment definition");
                this.typeName = qt.readNextRealToken(null, "reading fragment name");
            } else {
                this.typeName = null;
            }
        } else {
            this.name = qt.readNextRealToken(null, "reading fragment name");
            qt.readNextRealToken("on", "looking for the 'on' token of the fragment definition");
            this.typeName = qt.readNextRealToken(null, "reading fragment name");
        }
        while (qt.hasMoreTokens()) {
            String token = qt.nextToken();
            if (token.equals("@")) {
                this.directives.add(new Directive(qt));
                continue;
            }
            if (token.equals("{")) break;
            throw new GraphQLRequestPreparationException("Unexpected token '" + token + "' while searching for the starting '{' in fragment '" + this.getName() + "'");
        }
        if (this.typeName != null) {
            String classname = packageName + "." + GraphqlUtils.graphqlUtils.getJavaName(this.typeName);
            try {
                clazz = this.getClass().getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                throw new GraphQLRequestPreparationException("Could not load class '" + classname + "' for type '" + this.typeName + "'", e);
            }
        }
        this.content = new QueryField(clazz);
        this.content.readTokenizerForResponseDefinition(qt);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void appendToGraphQLRequests(StringBuilder sb, Map<String, Object> params) throws GraphQLRequestExecutionException {
        if (this.name != null) {
            sb.append("fragment ");
            sb.append(this.name);
        }
        if (this.typeName != null) {
            sb.append(" on ");
            sb.append(this.typeName);
        }
        for (Directive d : this.directives) {
            d.appendToGraphQLRequests(sb, params);
        }
        this.content.appendToGraphQLRequests(sb, params, false);
    }

    public void addTypenameFields() throws GraphQLRequestPreparationException {
        this.content.addTypenameFields();
    }
}

