/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class SubscriptionClientWebSocket<R, T> {
    private static Logger logger = LoggerFactory.getLogger(SubscriptionClientWebSocket.class);
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    final String request;
    final String subscriptionName;
    final SubscriptionCallback<T> subscriptionCallback;
    ObjectMapper objectMapper;
    Class<R> subscriptionType;
    Class<T> messageType;

    SubscriptionClientWebSocket(String request, String subscriptionName, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messsageType) {
        this.request = request;
        this.subscriptionName = subscriptionName;
        this.subscriptionCallback = subscriptionCallback;
        this.objectMapper = new ObjectMapper();
        this.subscriptionType = subscriptionType;
        this.messageType = messsageType;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        logger.debug("Web Socket connected (session {}) for request {}", (Object)session, (Object)this.request);
        try {
            session.getRemote().sendStringByFuture(this.request);
        }
        catch (Throwable t) {
            this.subscriptionCallback.onError(new GraphQLRequestPreparationException("Error while submitting the subscription request<" + this.request + ">", t));
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        try {
            Object r = this.objectMapper.readValue(msg, this.subscriptionType);
            Object t = this.graphqlUtils.invokeGetter(r, this.subscriptionName);
            this.subscriptionCallback.onMessage(t);
        }
        catch (IOException e) {
            String errorMsg = "An error (" + e.getMessage() + ") occured while parsing a server message for subscription '" + this.subscriptionName + "'";
            if (logger.isTraceEnabled()) {
                errorMsg = errorMsg + ". The received message is <" + msg + ">";
            }
            logger.error(errorMsg);
            this.subscriptionCallback.onError(new GraphQLRequestExecutionException(errorMsg, e));
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        logger.debug("Connection closed (status {}, reason {}) for request {}", new Object[]{statusCode, reason, this.request});
        this.subscriptionCallback.onClose(statusCode, reason);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        logger.error("WebSocket Error: {}", (Object)cause.getMessage());
        this.subscriptionCallback.onError(cause);
    }
}

