/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator;

import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class GraphqlUtils {
    public static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    List<Class<?>> scalars = new ArrayList();
    private List<String> javaKeywords = new ArrayList<String>();
    public static Character JAVA_KEYWORD_PREFIX = Character.valueOf('_');

    public GraphqlUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
        this.javaKeywords.add("abstract");
        this.javaKeywords.add("assert");
        this.javaKeywords.add("boolean");
        this.javaKeywords.add("break");
        this.javaKeywords.add("byte");
        this.javaKeywords.add("case");
        this.javaKeywords.add("catch");
        this.javaKeywords.add("char");
        this.javaKeywords.add("class");
        this.javaKeywords.add("const");
        this.javaKeywords.add("continue");
        this.javaKeywords.add("default");
        this.javaKeywords.add("do");
        this.javaKeywords.add("double");
        this.javaKeywords.add("else");
        this.javaKeywords.add("enum");
        this.javaKeywords.add("extends");
        this.javaKeywords.add("final");
        this.javaKeywords.add("finally");
        this.javaKeywords.add("float");
        this.javaKeywords.add("for");
        this.javaKeywords.add("goto");
        this.javaKeywords.add("if");
        this.javaKeywords.add("implements");
        this.javaKeywords.add("import");
        this.javaKeywords.add("instanceof");
        this.javaKeywords.add("int");
        this.javaKeywords.add("interface");
        this.javaKeywords.add("long");
        this.javaKeywords.add("native");
        this.javaKeywords.add("new");
        this.javaKeywords.add("package");
        this.javaKeywords.add("private");
        this.javaKeywords.add("protected");
        this.javaKeywords.add("public");
        this.javaKeywords.add("return");
        this.javaKeywords.add("short");
        this.javaKeywords.add("static");
        this.javaKeywords.add("strictfp");
        this.javaKeywords.add("super");
        this.javaKeywords.add("switch");
        this.javaKeywords.add("synchronized");
        this.javaKeywords.add("this");
        this.javaKeywords.add("throw");
        this.javaKeywords.add("throws");
        this.javaKeywords.add("transient");
        this.javaKeywords.add("try");
        this.javaKeywords.add("void");
        this.javaKeywords.add("volatile");
        this.javaKeywords.add("while");
    }

    public String getPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public <T> T getInputObject(Map<String, Object> map, Class<T> clazz) {
        T t;
        if (map == null) {
            return null;
        }
        try {
            t = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error while creating a new instance of  '" + clazz.getName() + " class", e);
        }
        for (String key : map.keySet()) {
            Field field;
            try {
                field = clazz.getDeclaredField(key);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Error while reading '" + key + "' field for the " + clazz.getName() + " class", e);
            }
            Method setter = this.getSetter(clazz, field);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            if (graphQLScalar != null) {
                if (graphQLScalar.javaClass() == UUID.class) {
                    this.invokeMethod(setter, t, UUID.fromString((String)map.get(key)));
                    continue;
                }
                if (graphQLScalar.javaClass() == String.class || graphQLScalar.javaClass() == Boolean.class || graphQLScalar.javaClass() == Integer.class || graphQLScalar.javaClass() == Float.class || graphQLScalar.javaClass().isEnum()) {
                    this.invokeMethod(setter, t, map.get(key));
                    continue;
                }
                throw new RuntimeException("Non managed type when reading the input map: '" + graphQLScalar.javaClass().getName());
            }
            if (graphQLNonScalar != null) {
                if (!(map.get(key) instanceof Map)) {
                    throw new RuntimeException("The value for the field '" + clazz.getName() + "." + key + " should be a map");
                }
                Map subMap = (Map)map.get(key);
                this.invokeMethod(setter, t, this.getInputObject(subMap, graphQLNonScalar.javaClass()));
                continue;
            }
            throw new RuntimeException("Internal error: the field '" + clazz.getName() + "." + key + "' should have one of these annotations: GraphQLScalar or GraphQLScalar");
        }
        return t;
    }

    public <T> List<T> getListInputObjects(List<Map<String, Object>> list, Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>(list.size());
        for (Map<String, Object> map : list) {
            ret.add(this.getInputObject(map, clazz));
        }
        return ret;
    }

    public <T> Method getSetter(Class<T> clazz, Field field) {
        String setterMethodName = "set" + this.getPascalCase(field.getName());
        try {
            return clazz.getDeclaredMethod(setterMethodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The setter '" + setterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the setter '" + setterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public <T> Method getGetter(Class<T> clazz, Field field) {
        String setterMethodName = "get" + this.getPascalCase(field.getName());
        try {
            Method method = clazz.getDeclaredMethod(setterMethodName, new Class[0]);
            if (field.getType() != method.getReturnType()) {
                throw new RuntimeException("The getter '" + setterMethodName + "' and the field '" + field.getName() + "' of the class " + clazz.getName() + " should be of the same type");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The getter '" + setterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the getter '" + setterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Object invokeGetter(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            Method getter = this.getGetter(object.getClass(), field);
            return getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the getter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void invokeSetter(Object object, Field field, Object value) {
        try {
            Method setter = this.getSetter(object.getClass(), field);
            setter.invoke(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + field.getName() + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void invokeSetter(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            this.invokeSetter(object, field, value);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public Method getMethod(String methodName, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get the method '" + methodName + "' in the " + clazz.getName() + " class", e);
        }
    }

    public Object invokeMethod(Method method, Object o, Object ... args) {
        try {
            return method.invoke(o, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error when executing the method '" + method.getName() + "' is missing in " + o.getClass().getName() + " class", e);
        }
    }

    public String getJavaName(String name) {
        return this.isJavaReservedWords(name) ? JAVA_KEYWORD_PREFIX + name : name;
    }

    public boolean isJavaReservedWords(String name) {
        return this.javaKeywords.contains(name);
    }
}

