/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.server.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class QueryParameters {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private String query;
    private String operationName;
    private Map<String, Object> variables = Collections.emptyMap();

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static QueryParameters from(String queryMessage) {
        Map json;
        QueryParameters parameters = new QueryParameters();
        try {
            json = (Map)objectMapper.readValue(queryMessage, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        parameters.query = (String)json.get("query");
        parameters.operationName = (String)json.get("operationName");
        parameters.variables = QueryParameters.getVariables((Map)json.get("variables"));
        return parameters;
    }

    private static Map<String, Object> getVariables(Map<?, ?> variables) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        variables.forEach((k, v) -> vars.put(String.valueOf(k), v));
        return vars;
    }
}

