/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.DefaultTypeFunction;
import graphql.annotations.GraphQLInvokeDetached;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class MethodDataFetcher
implements DataFetcher {
    private final Method method;

    public MethodDataFetcher(Method method) {
        this.method = method;
    }

    public Object get(DataFetchingEnvironment environment) {
        try {
            Object obj;
            if (Modifier.isStatic(this.method.getModifiers())) {
                obj = null;
            } else if (this.method.getAnnotation(GraphQLInvokeDetached.class) == null) {
                obj = environment.getSource();
                if (obj == null) {
                    return null;
                }
            } else {
                obj = this.method.getDeclaringClass().newInstance();
            }
            return this.method.invoke(obj, this.invocationArgs(environment));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] invocationArgs(DataFetchingEnvironment environment) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator envArgs = environment.getArguments().values().iterator();
        DefaultTypeFunction typeFunction = new DefaultTypeFunction();
        for (Parameter p : this.method.getParameters()) {
            Class<?> paramType = p.getType();
            if (DataFetchingEnvironment.class.isAssignableFrom(paramType)) {
                result.add(environment);
                continue;
            }
            GraphQLType graphQLType = (GraphQLType)typeFunction.apply(paramType, p.getAnnotatedType());
            if (graphQLType instanceof GraphQLObjectType) {
                Constructor<?> constructor = paramType.getConstructor(HashMap.class);
                result.add(constructor.newInstance(envArgs.next()));
                continue;
            }
            result.add(envArgs.next());
        }
        return result.toArray();
    }
}

