/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.Scalars;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.constraints.Documentation;
import graphql.validation.rules.ValidationEnvironment;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternConstraint
extends AbstractDirectiveConstraint {
    private static final Map<String, Pattern> SEEN_PATTERNS = new HashMap<String, Pattern>();

    public PatternConstraint() {
        super("Pattern");
    }

    @Override
    public Documentation getDocumentation() {
        return Documentation.newDocumentation().messageTemplate(this.getMessageTemplate()).description("The String must match the specified regular expression, which follows the Java regular expression conventions.").example("updateDriver( licencePlate : String @Pattern(regexp : \"[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]\") : DriverDetails").applicableTypeNames(Scalars.GraphQLString.getName(), "Lists").directiveSDL("directive @Pattern(regexp : String! =\".*\", message : String = \"%s\") on ARGUMENT_DEFINITION | INPUT_FIELD_DEFINITION", this.getMessageTemplate()).build();
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, Scalars.GraphQLString) || GraphQLTypeUtil.isList((GraphQLType)inputType);
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        Object validatedValue = validationEnvironment.getValidatedValue();
        GraphQLInputType argumentType = validationEnvironment.getValidatedType();
        if (validatedValue == null) {
            return Collections.emptyList();
        }
        List<Object> validatedValues = GraphQLTypeUtil.isList((GraphQLType)argumentType) ? (List<Object>)validatedValue : Arrays.asList(validatedValue);
        for (Object e : validatedValues) {
            String strValue = String.valueOf(e);
            GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
            String patternArg = this.getStrArg(directive, "regexp");
            Pattern pattern = this.cachedPattern(patternArg);
            Matcher matcher = pattern.matcher(strValue);
            if (matcher.matches()) continue;
            return this.mkError(validationEnvironment, directive, this.mkMessageParams(validatedValue, validationEnvironment, "regexp", patternArg));
        }
        return Collections.emptyList();
    }

    private Pattern cachedPattern(String patternArg) {
        return SEEN_PATTERNS.computeIfAbsent(patternArg, Pattern::compile);
    }
}

