/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.locale.LocaleUtil;
import graphql.validation.rules.ValidationCoordinates;
import graphql.validation.rules.ValidationEnvironment;
import graphql.validation.rules.ValidationRule;
import graphql.validation.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@PublicApi
public class TargetedValidationRules {
    private final Map<ValidationCoordinates, List<ValidationRule>> rulesMap;

    public TargetedValidationRules(Builder builder) {
        this.rulesMap = new HashMap<ValidationCoordinates, List<ValidationRule>>(builder.rulesMap);
    }

    public static Builder newValidationRules() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.rulesMap.isEmpty();
    }

    public List<GraphQLError> runValidationRules(DataFetchingEnvironment env, MessageInterpolator interpolator, Locale defaultLocale) {
        defaultLocale = LocaleUtil.determineLocale(env, defaultLocale);
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        GraphQLObjectType fieldContainer = env.getExecutionStepInfo().getFieldContainer();
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        ExecutionPath fieldPath = env.getExecutionStepInfo().getPath();
        ValidationCoordinates fieldCoords = ValidationCoordinates.newCoordinates((GraphQLFieldsContainer)fieldContainer, fieldDefinition);
        List rules = this.rulesMap.getOrDefault(fieldCoords, Collections.emptyList());
        if (!rules.isEmpty()) {
            ValidationEnvironment ruleEnvironment = ValidationEnvironment.newValidationEnvironment().dataFetchingEnvironment(env).messageInterpolator(interpolator).locale(defaultLocale).validatedElement(ValidationEnvironment.ValidatedElement.FIELD).validatedPath(fieldPath).build();
            for (ValidationRule rule : rules) {
                List<GraphQLError> ruleErrors = rule.runValidation(ruleEnvironment);
                errors.addAll(ruleErrors);
            }
        }
        List<GraphQLArgument> sortedArgs = Util.sort(fieldDefinition.getArguments(), GraphQLArgument::getName);
        for (GraphQLArgument fieldArg : sortedArgs) {
            ValidationCoordinates argCoords = ValidationCoordinates.newCoordinates((GraphQLFieldsContainer)fieldContainer, fieldDefinition, fieldArg);
            rules = this.rulesMap.getOrDefault(argCoords, Collections.emptyList());
            if (rules.isEmpty()) continue;
            Object argValue = env.getArgument(fieldArg.getName());
            GraphQLInputType inputType = fieldArg.getType();
            ValidationEnvironment ruleEnvironment = ValidationEnvironment.newValidationEnvironment().dataFetchingEnvironment(env).argument(fieldArg).validatedElement(ValidationEnvironment.ValidatedElement.ARGUMENT).validatedType(inputType).validatedValue(argValue).validatedPath(fieldPath.segment(fieldArg.getName())).directives(fieldArg.getDirectives()).messageInterpolator(interpolator).locale(defaultLocale).build();
            for (ValidationRule rule : rules) {
                List<GraphQLError> ruleErrors = this.runValidationImpl(rule, ruleEnvironment, inputType, argValue);
                errors.addAll(ruleErrors);
            }
        }
        return errors;
    }

    private List<GraphQLError> runValidationImpl(ValidationRule rule, ValidationEnvironment validationEnvironment, GraphQLInputType inputType, Object validatedValue) {
        List<GraphQLError> ruleErrors;
        List<GraphQLError> errors = rule.runValidation(validationEnvironment);
        if (validatedValue == null) {
            return errors;
        }
        if (GraphQLTypeUtil.isList((GraphQLType)(inputType = (GraphQLInputType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)inputType)))) {
            ArrayList<Object> values = new ArrayList<Object>(FpKit.toCollection((Object)validatedValue));
            ruleErrors = this.walkListArg(rule, validationEnvironment, (GraphQLList)inputType, values);
            errors.addAll(ruleErrors);
        }
        if (inputType instanceof GraphQLInputObjectType) {
            if (validatedValue instanceof Map) {
                Map objectValue = (Map)validatedValue;
                ruleErrors = this.walkObjectArg(rule, validationEnvironment, (GraphQLInputObjectType)inputType, objectValue);
                errors.addAll(ruleErrors);
            } else {
                Assert.assertShouldNeverHappen((String)"How can there be a `input` object type '%s' that does not have a matching Map java value", (Object[])new Object[]{GraphQLTypeUtil.simplePrint((GraphQLType)inputType)});
            }
        }
        return errors;
    }

    private List<GraphQLError> walkObjectArg(ValidationRule rule, ValidationEnvironment validationEnvironment, GraphQLInputObjectType argumentType, Map<String, Object> objectMap) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        List<GraphQLInputObjectField> fieldDefinitions = Util.sort(argumentType.getFieldDefinitions(), GraphQLInputObjectField::getName);
        for (GraphQLInputObjectField inputField : fieldDefinitions) {
            GraphQLInputType fieldType = inputField.getType();
            List directives = inputField.getDirectives();
            Object validatedValue = objectMap.getOrDefault(inputField.getName(), inputField.getDefaultValue());
            if (validatedValue == null) continue;
            ExecutionPath newPath = validationEnvironment.getValidatedPath().segment(inputField.getName());
            ValidationEnvironment newValidationEnvironment = validationEnvironment.transform(builder -> builder.validatedPath(newPath).validatedValue(validatedValue).validatedType(fieldType).directives(inputField.getDirectives()).validatedElement(ValidationEnvironment.ValidatedElement.INPUT_OBJECT_FIELD));
            List<GraphQLError> ruleErrors = this.runValidationImpl(rule, newValidationEnvironment, fieldType, validatedValue);
            errors.addAll(ruleErrors);
        }
        return errors;
    }

    private List<GraphQLError> walkListArg(ValidationRule rule, ValidationEnvironment validationEnvironment, GraphQLList argumentType, List<Object> objectList) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        GraphQLInputType listItemType = Util.unwrapOneAndAllNonNull((GraphQLInputType)argumentType);
        List directives = !(listItemType instanceof GraphQLDirectiveContainer) ? Collections.emptyList() : ((GraphQLDirectiveContainer)listItemType).getDirectives();
        int ix = 0;
        for (Object value : objectList) {
            ExecutionPath newPath = validationEnvironment.getValidatedPath().segment(ix);
            ValidationEnvironment newValidationEnvironment = validationEnvironment.transform(builder -> builder.validatedPath(newPath).validatedValue(value).validatedType(listItemType).directives(directives));
            List<GraphQLError> ruleErrors = this.runValidationImpl(rule, newValidationEnvironment, listItemType, value);
            errors.addAll(ruleErrors);
            ++ix;
        }
        return errors;
    }

    public static class Builder {
        Map<ValidationCoordinates, List<ValidationRule>> rulesMap = new HashMap<ValidationCoordinates, List<ValidationRule>>();

        public Builder addRule(ValidationCoordinates coordinates, ValidationRule rule) {
            this.rulesMap.compute(coordinates, (key, listOfRules) -> {
                if (listOfRules == null) {
                    listOfRules = new ArrayList<ValidationRule>();
                }
                listOfRules.add(rule);
                return listOfRules;
            });
            return this;
        }

        public Builder addRules(ValidationCoordinates argCoords, List<ValidationRule> rules) {
            for (ValidationRule rule : rules) {
                this.addRule(argCoords, rule);
            }
            return this;
        }

        public TargetedValidationRules build() {
            return new TargetedValidationRules(this);
        }
    }
}

