/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.util;

import graphql.Internal;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.validation.util.Util;
import java.util.List;
import java.util.function.BiFunction;

@Internal
public class DirectivesAndTypeWalker {
    public static boolean isSuitable(GraphQLArgument argument, BiFunction<GraphQLInputType, GraphQLDirective, Boolean> isSuitable) {
        GraphQLInputType inputType = argument.getType();
        List directives = argument.getDirectives();
        return DirectivesAndTypeWalker.walkInputType(inputType, directives, isSuitable);
    }

    private static boolean walkInputType(GraphQLInputType inputType, List<GraphQLDirective> directives, BiFunction<GraphQLInputType, GraphQLDirective, Boolean> isSuitable) {
        GraphQLInputType innerListType;
        GraphQLInputType unwrappedInputType = Util.unwrapNonNull(inputType);
        for (GraphQLDirective directive : directives) {
            if (!isSuitable.apply(unwrappedInputType, directive).booleanValue()) continue;
            return true;
        }
        if (unwrappedInputType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjType = (GraphQLInputObjectType)unwrappedInputType;
            for (GraphQLInputObjectField inputField : inputObjType.getFieldDefinitions()) {
                inputType = inputField.getType();
                if (!DirectivesAndTypeWalker.walkInputType(inputType, directives = inputField.getDirectives(), isSuitable)) continue;
                return true;
            }
        }
        return unwrappedInputType instanceof GraphQLList && (innerListType = Util.unwrapOneAndAllNonNull(unwrappedInputType)) instanceof GraphQLDirectiveContainer && DirectivesAndTypeWalker.walkInputType(innerListType, directives = ((GraphQLDirectiveContainer)innerListType).getDirectives(), isSuitable);
    }
}

