/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.util;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@Internal
public class Util {
    public static GraphQLInputType unwrapOneAndAllNonNull(GraphQLInputType inputType) {
        GraphQLType type = GraphQLTypeUtil.unwrapNonNull((GraphQLType)inputType);
        type = GraphQLTypeUtil.unwrapOne((GraphQLType)type);
        if ((type = GraphQLTypeUtil.unwrapNonNull((GraphQLType)type)) instanceof GraphQLInputType) {
            return (GraphQLInputType)type;
        }
        String argType = GraphQLTypeUtil.simplePrint((GraphQLType)inputType);
        return (GraphQLInputType)Assert.assertShouldNeverHappen((String)"You have a wrapped type that is in fact not a input type : %s", (Object[])new Object[]{argType});
    }

    public static GraphQLInputType unwrapNonNull(GraphQLInputType inputType) {
        GraphQLType type = GraphQLTypeUtil.unwrapNonNull((GraphQLType)inputType);
        if (type instanceof GraphQLInputType) {
            return (GraphQLInputType)type;
        }
        String argType = GraphQLTypeUtil.simplePrint((GraphQLType)inputType);
        return (GraphQLInputType)Assert.assertShouldNeverHappen((String)"You have a wrapped type that is in fact not a input type : %s", (Object[])new Object[]{argType});
    }

    public static Object mkDFRFromFetchedResult(List<GraphQLError> errors, Object value) {
        if (value instanceof CompletionStage) {
            return ((CompletionStage)value).thenApply(v -> Util.mkDFRFromFetchedResult(errors, v));
        }
        if (value instanceof DataFetcherResult) {
            DataFetcherResult df = (DataFetcherResult)value;
            return Util.mkDFR(df.getData(), Util.concat(errors, df.getErrors()), df.getLocalContext());
        }
        return Util.mkDFR(value, errors, null);
    }

    public static DataFetcherResult<Object> mkDFR(Object value, List<GraphQLError> errors, Object localContext) {
        return DataFetcherResult.newResult().data(value).errors(errors).localContext(localContext).build();
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> errors = new ArrayList<T>();
        errors.addAll(l1);
        errors.addAll(l2);
        return errors;
    }

    public static <T, U extends Comparable<? super U>> List<T> sort(Collection<T> toBeSorted, Function<? super T, ? extends U> keyExtractor) {
        ArrayList<T> l = new ArrayList<T>(toBeSorted);
        l.sort(Comparator.comparing(keyExtractor));
        return l;
    }

    public static ExecutionPath concatPaths(ExecutionPath parent, ExecutionPath child) {
        if (child == null) {
            return parent;
        }
        List segments = child.toList();
        for (Object segment : segments) {
            if (segment instanceof Integer) {
                parent = parent.segment(((Integer)segment).intValue());
                continue;
            }
            parent = parent.segment(String.valueOf(segment));
        }
        return parent;
    }

    public static Map<String, Object> mkMap(Object ... args) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Assert.assertTrue((args.length % 2 == 0 ? 1 : 0) != 0, () -> "You MUST pass in an even number of arguments");
        for (int ix = 0; ix < args.length; ix += 2) {
            Object key = args[ix];
            Assert.assertTrue((boolean)(key instanceof String), () -> "You MUST pass in a message param string key");
            Object val = args[ix + 1];
            params.put(String.valueOf(key), val);
        }
        return params;
    }
}

