/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.List;

public class GraphQLUnionType
implements GraphQLType,
GraphQLOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private List<GraphQLType> types = new ArrayList<GraphQLType>();
    private final TypeResolver typeResolver;

    public GraphQLUnionType(String name, String description, List<GraphQLType> types, TypeResolver typeResolver) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(types, "types can't be null");
        Assert.assertNotNull(typeResolver, "typeResolver can't be null");
        this.name = name;
        this.description = description;
        this.types.addAll(types);
        this.typeResolver = typeResolver;
    }

    public List<GraphQLType> getTypes() {
        return new ArrayList<GraphQLType>(this.types);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder newUnionType() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLType> types = new ArrayList<GraphQLType>();
        private TypeResolver typeResolver;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder possibleType(GraphQLType type) {
            Assert.assertNotNull(type, "possible type can't be null");
            this.types.add(type);
            return this;
        }

        public Builder possibleTypes(GraphQLType ... type) {
            for (GraphQLType graphQLType : type) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public GraphQLUnionType build() {
            return new GraphQLUnionType(this.name, this.description, this.types, this.typeResolver);
        }
    }
}

