/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLDirective;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.List;

public class KnownDirectives
extends AbstractRule {
    public KnownDirectives(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        String message;
        GraphQLDirective graphQLDirective = this.getValidationContext().getSchema().getDirective(directive.getName());
        if (graphQLDirective == null) {
            String message2 = String.format("Unknown directive %s", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.UnknownDirective, directive.getSourceLocation(), message2));
            return;
        }
        Node ancestor = ancestors.get(ancestors.size() - 1);
        if (ancestor instanceof OperationDefinition && !graphQLDirective.isOnOperation()) {
            message = String.format("Directive %s not allowed here", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message));
        }
        if (ancestor instanceof Field && !graphQLDirective.isOnField()) {
            message = String.format("Directive %s not allowed here", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message));
        }
        if ((ancestor instanceof FragmentSpread || ancestor instanceof FragmentDefinition || ancestor instanceof InlineFragment) && !graphQLDirective.isOnFragment()) {
            message = String.format("Directive %s not allowed here", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message));
        }
    }
}

