/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import graphql.ExecutionResult;
import graphql.servlet.internal.GraphQLRequest;
import graphql.servlet.internal.SubscriptionHandlerInput;
import graphql.servlet.internal.SubscriptionProtocolHandler;
import graphql.servlet.internal.WsSessionSubscriptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloSubscriptionProtocolHandler
extends SubscriptionProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
    private static final CloseReason TERMINATE_CLOSE_REASON = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "client requested " + OperationMessage.Type.GQL_CONNECTION_TERMINATE.getType());
    private final SubscriptionHandlerInput input;

    public ApolloSubscriptionProtocolHandler(SubscriptionHandlerInput subscriptionHandlerInput) {
        this.input = subscriptionHandlerInput;
    }

    @Override
    public void onMessage(HandshakeRequest request, Session session, WsSessionSubscriptions subscriptions, String text) {
        OperationMessage message;
        try {
            message = (OperationMessage)this.input.getGraphQLObjectMapper().getJacksonMapper().readValue(text, OperationMessage.class);
        }
        catch (Throwable t) {
            log.warn("Error parsing message", t);
            this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_ERROR, null);
            return;
        }
        switch (message.getType()) {
            case GQL_CONNECTION_INIT: {
                this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_ACK, message.getId());
                this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_KEEP_ALIVE, message.getId());
                break;
            }
            case GQL_START: {
                this.handleSubscriptionStart(session, subscriptions, message.id, this.input.getQueryInvoker().query(this.input.getInvocationInputFactory().create((GraphQLRequest)this.input.getGraphQLObjectMapper().getJacksonMapper().convertValue(message.payload, GraphQLRequest.class))));
                break;
            }
            case GQL_STOP: {
                this.unsubscribe(subscriptions, message.id);
                break;
            }
            case GQL_CONNECTION_TERMINATE: {
                try {
                    session.close(TERMINATE_CLOSE_REASON);
                }
                catch (IOException e) {
                    log.error("Error closing websocket session!", (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type: " + (Object)((Object)message.getType()));
            }
        }
    }

    private void handleSubscriptionStart(Session session, WsSessionSubscriptions subscriptions, String id, ExecutionResult executionResult) {
        executionResult = this.input.getGraphQLObjectMapper().sanitizeErrors(executionResult);
        if (this.input.getGraphQLObjectMapper().areErrorsPresent(executionResult)) {
            this.sendMessage(session, OperationMessage.Type.GQL_ERROR, id, this.input.getGraphQLObjectMapper().convertSanitizedExecutionResult(executionResult, false));
            return;
        }
        this.subscribe(session, executionResult, subscriptions, id);
    }

    @Override
    protected void sendDataMessage(Session session, String id, Object payload) {
        this.sendMessage(session, OperationMessage.Type.GQL_DATA, id, payload);
    }

    @Override
    protected void sendErrorMessage(Session session, String id) {
        this.sendMessage(session, OperationMessage.Type.GQL_ERROR, id);
    }

    @Override
    protected void sendCompleteMessage(Session session, String id) {
        this.sendMessage(session, OperationMessage.Type.GQL_COMPLETE, id);
    }

    private void sendMessage(Session session, OperationMessage.Type type, String id) {
        this.sendMessage(session, type, id, null);
    }

    private void sendMessage(Session session, OperationMessage.Type type, String id, Object payload) {
        try {
            session.getBasicRemote().sendText(this.input.getGraphQLObjectMapper().getJacksonMapper().writeValueAsString((Object)new OperationMessage(type, id, payload)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error sending subscription response", e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class OperationMessage {
        private Type type;
        private String id;
        private Object payload;

        public OperationMessage() {
        }

        public OperationMessage(Type type, String id, Object payload) {
            this.type = type;
            this.id = id;
            this.payload = payload;
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Object getPayload() {
            return this.payload;
        }

        public static enum Type {
            GQL_CONNECTION_ACK("connection_ack"),
            GQL_CONNECTION_ERROR("connection_error"),
            GQL_CONNECTION_KEEP_ALIVE("ka"),
            GQL_DATA("data"),
            GQL_ERROR("error"),
            GQL_COMPLETE("complete"),
            GQL_CONNECTION_INIT("connection_init"),
            GQL_CONNECTION_TERMINATE("connection_terminate"),
            GQL_START("start"),
            GQL_STOP("stop");

            private static final Map<String, Type> reverseLookup;
            private final String type;

            private Type(String type) {
                this.type = type;
            }

            @JsonCreator
            public static Type findType(String type) {
                return reverseLookup.get(type);
            }

            @JsonValue
            public String getType() {
                return this.type;
            }

            static {
                reverseLookup = new HashMap<String, Type>();
                for (Type type : Type.values()) {
                    reverseLookup.put(type.getType(), type);
                }
            }
        }
    }
}

