/*
 * Decompiled with CFR 0.152.
 */
package graphql.spring.web.reactive.components;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.Internal;
import graphql.spring.web.reactive.ExecutionInputCustomizer;
import graphql.spring.web.reactive.GraphQLInvocation;
import graphql.spring.web.reactive.GraphQLInvocationData;
import java.util.concurrent.CompletionStage;
import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@Internal
public class DefaultGraphQLInvocation
implements GraphQLInvocation {
    @Autowired
    GraphQL graphQL;
    @Autowired(required=false)
    DataLoaderRegistry dataLoaderRegistry;
    @Autowired
    ExecutionInputCustomizer executionInputCustomizer;

    @Override
    public Mono<ExecutionResult> invoke(GraphQLInvocationData invocationData, ServerWebExchange serverWebExchange) {
        ExecutionInput.Builder executionInputBuilder = ExecutionInput.newExecutionInput().query(invocationData.getQuery()).operationName(invocationData.getOperationName()).variables(invocationData.getVariables());
        if (this.dataLoaderRegistry != null) {
            executionInputBuilder.dataLoaderRegistry(this.dataLoaderRegistry);
        }
        ExecutionInput executionInput = executionInputBuilder.build();
        Mono<ExecutionInput> customizedExecutionInputMono = this.executionInputCustomizer.customizeExecutionInput(executionInput, serverWebExchange);
        return customizedExecutionInputMono.flatMap(customizedExecutionInput -> Mono.fromCompletionStage((CompletionStage)this.graphQL.executeAsync(customizedExecutionInput)));
    }
}

