/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.imsweb.seerapi.client.ErrorResponseFilter;
import com.imsweb.seerapi.client.cs.CsCodeValidity;
import com.imsweb.seerapi.client.cs.CsInput;
import com.imsweb.seerapi.client.cs.CsResult;
import com.imsweb.seerapi.client.cs.CsSchema;
import com.imsweb.seerapi.client.cs.CsSchemaExistence;
import com.imsweb.seerapi.client.cs.CsSchemaName;
import com.imsweb.seerapi.client.cs.CsTable;
import com.imsweb.seerapi.client.cs.CsVersion;
import com.imsweb.seerapi.client.disease.Disease;
import com.imsweb.seerapi.client.disease.DiseaseChangelog;
import com.imsweb.seerapi.client.disease.DiseaseSearch;
import com.imsweb.seerapi.client.disease.DiseaseSearchResults;
import com.imsweb.seerapi.client.disease.DiseaseVersion;
import com.imsweb.seerapi.client.disease.PrimarySite;
import com.imsweb.seerapi.client.disease.SamePrimaries;
import com.imsweb.seerapi.client.disease.SiteCategory;
import com.imsweb.seerapi.client.glossary.Glossary;
import com.imsweb.seerapi.client.glossary.GlossaryChangelog;
import com.imsweb.seerapi.client.glossary.GlossarySearch;
import com.imsweb.seerapi.client.glossary.GlossarySearchResults;
import com.imsweb.seerapi.client.glossary.GlossaryVersion;
import com.imsweb.seerapi.client.naaccr.NaaccrField;
import com.imsweb.seerapi.client.naaccr.NaaccrFieldName;
import com.imsweb.seerapi.client.naaccr.NaaccrVersion;
import com.imsweb.seerapi.client.rx.Rx;
import com.imsweb.seerapi.client.rx.RxChangelog;
import com.imsweb.seerapi.client.rx.RxSearch;
import com.imsweb.seerapi.client.rx.RxSearchResults;
import com.imsweb.seerapi.client.rx.RxVersion;
import com.imsweb.seerapi.client.shared.Version;
import com.imsweb.seerapi.client.siterecode.SiteRecode;
import com.imsweb.seerapi.client.staging.StagingAlgorithm;
import com.imsweb.seerapi.client.staging.StagingOutput;
import com.imsweb.seerapi.client.staging.StagingSchema;
import com.imsweb.seerapi.client.staging.StagingSchemaInfo;
import com.imsweb.seerapi.client.staging.StagingTable;
import com.imsweb.seerapi.client.staging.StagingVersion;
import com.imsweb.seerapi.client.surgery.SurgeryTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.glassfish.jersey.message.GZipEncoder;

public final class SeerApi {
    private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest";
    private static final String _ENV_API_KEY = "SEER_API_KEY";
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final JacksonJsonProvider _JACKSON_PROVIDER = new JacksonJsonProvider();
    private Client _client;
    private String _baseUrl;
    private String _apiKey;

    private SeerApi(String baseUrl, String apiKey) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this._baseUrl = baseUrl;
        this._apiKey = apiKey;
        this._client = (Client)((Client)((Client)ClientBuilder.newClient().register((Object)_JACKSON_PROVIDER)).register(GZipEncoder.class)).register(ErrorResponseFilter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        Properties props = new Properties();
        File config = new File(System.getProperty("user.home"), ".seerapi");
        if (config.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(config);
                props.load(in);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    public static SeerApi connect() {
        String apiKey;
        Properties props = SeerApi.getProperties();
        String url = props.getProperty("url");
        if (url == null) {
            url = _SEERAPI_URL;
        }
        if ((apiKey = props.getProperty("apikey")) == null) {
            apiKey = System.getenv(_ENV_API_KEY);
        }
        return new SeerApi(url, apiKey);
    }

    public static SeerApi connect(String apiKey) {
        Properties props = SeerApi.getProperties();
        String url = props.getProperty("url");
        if (url == null) {
            url = _SEERAPI_URL;
        }
        return new SeerApi(url, apiKey);
    }

    public static SeerApi connect(String baseUrl, String apiKey) {
        return new SeerApi(baseUrl, apiKey);
    }

    private WebTarget createTarget(String path) {
        if (this._apiKey == null || this._apiKey.isEmpty()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the SeerApi constructor");
        }
        return this._client.target(this._baseUrl).path(path);
    }

    private Invocation.Builder getBuilder(WebTarget target) {
        return target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-SEERAPI-Key", (Object)this._apiKey).acceptEncoding(new String[]{"gzip"});
    }

    public String siteRecodeVersion() {
        WebTarget target = this.createTarget("/recode/version");
        return ((Version)this.getBuilder(target).get(Version.class)).getVersion();
    }

    public SiteRecode siteRecode(String site, String histology) {
        WebTarget target = this.createTarget("/recode/sitegroup").queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology});
        return (SiteRecode)this.getBuilder(target).get(SiteRecode.class);
    }

    public List<NaaccrVersion> naaccrVersions() {
        WebTarget target = this.createTarget("/naaccr/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<NaaccrVersion>>(){});
    }

    public List<NaaccrFieldName> naaccrFieldNames(String version) {
        WebTarget target = this.createTarget("/naaccr/{version}").resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<NaaccrFieldName>>(){});
    }

    public NaaccrField naaccrField(String version, Integer item) {
        WebTarget target = this.createTarget("/naaccr/{version}/item/{item}").resolveTemplate("version", (Object)version).resolveTemplate("item", (Object)item);
        return (NaaccrField)this.getBuilder(target).get(NaaccrField.class);
    }

    public List<CsVersion> csVersions() {
        WebTarget target = this.createTarget("/cstage/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<CsVersion>>(){});
    }

    public List<CsSchemaName> csSchemas(String version) {
        WebTarget target = this.createTarget("/cstage/{version}").resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<CsSchemaName>>(){});
    }

    public CsSchemaExistence csSchemaExists(String version, String site, String histology) {
        WebTarget target = this.createTarget("/cstage/{version}/check_schema_exists").resolveTemplate("version", (Object)version).queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology});
        return (CsSchemaExistence)this.getBuilder(target).get(CsSchemaExistence.class);
    }

    public CsSchema csSchema(String version, Integer schemaNumber) {
        WebTarget target = this.createTarget("/cstage/{version}/schema").resolveTemplate("version", (Object)version).queryParam("id", new Object[]{schemaNumber});
        return (CsSchema)this.getBuilder(target).get(CsSchema.class);
    }

    public CsSchema csSchema(String version, String site, String histology, String ssf25) {
        WebTarget target = this.createTarget("/cstage/{version}/schema").resolveTemplate("version", (Object)version).queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology}).queryParam("ssf25", new Object[]{ssf25});
        return (CsSchema)this.getBuilder(target).get(CsSchema.class);
    }

    public CsCodeValidity csValidCode(String version, Integer schemaNumber, Integer tableNumber, String code) {
        WebTarget target = this.createTarget("/cstage/{version}/is_code_valid").resolveTemplate("version", (Object)version).queryParam("id", new Object[]{schemaNumber}).queryParam("table", new Object[]{tableNumber}).queryParam("code", new Object[]{code});
        return (CsCodeValidity)this.getBuilder(target).get(CsCodeValidity.class);
    }

    public CsTable csTable(String version, Integer schemaNumber, Integer tableNumber) {
        WebTarget target = this.createTarget("/cstage/{version}/table").resolveTemplate("version", (Object)version).queryParam("id", new Object[]{schemaNumber}).queryParam("table", new Object[]{tableNumber});
        return (CsTable)this.getBuilder(target).get(CsTable.class);
    }

    public CsResult csCalculate(String version, CsInput input) {
        WebTarget target = this.createTarget("/cstage/{version}/calculate").resolveTemplate("version", (Object)version);
        target = target.queryParam("site", new Object[]{input.getSite()}).queryParam("hist", new Object[]{input.getHistology()}).queryParam("diagnosis_year", new Object[]{input.getDiagnosisYear()}).queryParam("csver_original", new Object[]{input.getCsVersionOriginal()}).queryParam("behav", new Object[]{input.getBehavior()}).queryParam("grade", new Object[]{input.getGrade()}).queryParam("age", new Object[]{input.getAge()}).queryParam("lvi", new Object[]{input.getLvi()}).queryParam("size", new Object[]{input.getTumorSize()}).queryParam("ext", new Object[]{input.getExtension()}).queryParam("exteval", new Object[]{input.getExtensionEval()}).queryParam("nodes", new Object[]{input.getLymphNodes()}).queryParam("nodeseval", new Object[]{input.getLymphNodesEval()}).queryParam("lnpos", new Object[]{input.getLymphNodesPositive()}).queryParam("lnexam", new Object[]{input.getLymphNodesExamined()}).queryParam("mets", new Object[]{input.getMetsAtDx()}).queryParam("metseval", new Object[]{input.getMetsEval()}).queryParam("ssf1", new Object[]{input.getSsf1()}).queryParam("ssf2", new Object[]{input.getSsf2()}).queryParam("ssf3", new Object[]{input.getSsf3()}).queryParam("ssf4", new Object[]{input.getSsf4()}).queryParam("ssf5", new Object[]{input.getSsf5()}).queryParam("ssf6", new Object[]{input.getSsf6()}).queryParam("ssf7", new Object[]{input.getSsf7()}).queryParam("ssf8", new Object[]{input.getSsf8()}).queryParam("ssf9", new Object[]{input.getSsf9()}).queryParam("ssf10", new Object[]{input.getSsf10()}).queryParam("ssf11", new Object[]{input.getSsf11()}).queryParam("ssf12", new Object[]{input.getSsf12()}).queryParam("ssf13", new Object[]{input.getSsf13()}).queryParam("ssf14", new Object[]{input.getSsf14()}).queryParam("ssf15", new Object[]{input.getSsf15()}).queryParam("ssf16", new Object[]{input.getSsf16()}).queryParam("ssf17", new Object[]{input.getSsf17()}).queryParam("ssf18", new Object[]{input.getSsf18()}).queryParam("ssf19", new Object[]{input.getSsf19()}).queryParam("ssf10", new Object[]{input.getSsf20()}).queryParam("ssf21", new Object[]{input.getSsf21()}).queryParam("ssf22", new Object[]{input.getSsf22()}).queryParam("ssf23", new Object[]{input.getSsf23()}).queryParam("ssf24", new Object[]{input.getSsf24()}).queryParam("ssf25", new Object[]{input.getSsf25()});
        return (CsResult)this.getBuilder(target).get(CsResult.class);
    }

    public List<DiseaseVersion> diseaseVersions() {
        WebTarget target = this.createTarget("/disease/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<DiseaseVersion>>(){});
    }

    public List<DiseaseChangelog> diseaseChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/disease/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<DiseaseChangelog>>(){});
    }

    public DiseaseSearchResults diseaseSearch(String version, DiseaseSearch search) {
        WebTarget target = this.createTarget("/disease/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("type", new Object[]{search.getType()}).queryParam("site_category", new Object[]{search.getSiteCategory()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        return (DiseaseSearchResults)this.getBuilder(target).get(DiseaseSearchResults.class);
    }

    public Disease diseaseById(String version, String id) {
        return this.diseaseById(version, id, false);
    }

    public Disease diseaseById(String version, String id, boolean includeGlossary) {
        WebTarget target = this.createTarget("/disease/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id).queryParam("glossary", new Object[]{includeGlossary});
        return (Disease)this.getBuilder(target).get(Disease.class);
    }

    public List<PrimarySite> diseasePrimarySites() {
        WebTarget target = this.createTarget("/disease/primary_site");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<PrimarySite>>(){});
    }

    public List<PrimarySite> diseasePrimarySiteCode(String primarySite) {
        WebTarget target = this.createTarget("/disease/primary_site/{code}").resolveTemplate("code", (Object)primarySite);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<PrimarySite>>(){});
    }

    public List<SiteCategory> diseaseSiteCategories() {
        WebTarget target = this.createTarget("/disease/site_categories");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<SiteCategory>>(){});
    }

    public SamePrimaries diseaseSamePrimaries(String version, String morphology1, String morphology2, String year) {
        WebTarget target = this.createTarget("/disease/{version}/same_primary").resolveTemplate("version", (Object)version).queryParam("d1", new Object[]{morphology1}).queryParam("d2", new Object[]{morphology2}).queryParam("year", new Object[]{year});
        return (SamePrimaries)this.getBuilder(target).get(SamePrimaries.class);
    }

    public Disease diseaseReportability(Disease disease) {
        WebTarget target = this.createTarget("/disease/reportability");
        return (Disease)this.getBuilder(target).post(Entity.json((Object)disease), Disease.class);
    }

    public List<GlossaryVersion> glossaryVersions() {
        WebTarget target = this.createTarget("/glossary/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<GlossaryVersion>>(){});
    }

    public Glossary glossaryById(String version, String id) {
        WebTarget target = this.createTarget("/glossary/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (Glossary)this.getBuilder(target).get(Glossary.class);
    }

    public GlossarySearchResults glossarySearch(String version, GlossarySearch search) {
        WebTarget target = this.createTarget("/glossary/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        if (search.getCategory() != null) {
            target = target.queryParam("category", search.getCategory().toArray());
        }
        return (GlossarySearchResults)this.getBuilder(target).get(GlossarySearchResults.class);
    }

    public List<GlossaryChangelog> glossaryChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/glossary/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<GlossaryChangelog>>(){});
    }

    public List<Version> siteSpecificSurgeryVersions() {
        WebTarget target = this.createTarget("/surgery/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<Version>>(){});
    }

    public List<String> siteSpecificSurgeryTables(String version) {
        WebTarget target = this.createTarget("/surgery/{version}/tables").resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<String>>(){});
    }

    public SurgeryTable siteSpecificSurgeryTable(String version, String title, String site, String histology) {
        WebTarget target = this.createTarget("/surgery/{version}/table").resolveTemplate("version", (Object)version).queryParam("title", new Object[]{title}).queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology});
        return (SurgeryTable)this.getBuilder(target).get(SurgeryTable.class);
    }

    public List<RxVersion> rxVersions() {
        WebTarget target = this.createTarget("/rx/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<RxVersion>>(){});
    }

    public Rx rxById(String version, String id) {
        return this.rxById(version, id, false);
    }

    public Rx rxById(String version, String id, boolean includeGlossary) {
        WebTarget target = this.createTarget("/rx/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id).queryParam("glossary", new Object[]{includeGlossary});
        return (Rx)this.getBuilder(target).get(Rx.class);
    }

    public RxSearchResults rxSearch(String version, RxSearch search) {
        WebTarget target = this.createTarget("/rx/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("type", new Object[]{search.getType()}).queryParam("do_not_code", new Object[]{search.getDoNotCode()}).queryParam("category", new Object[]{search.getCategory()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        return (RxSearchResults)this.getBuilder(target).get(RxSearchResults.class);
    }

    public List<RxChangelog> rxChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/rx/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<RxChangelog>>(){});
    }

    public List<StagingAlgorithm> stagingAlgorithms() {
        WebTarget target = this.createTarget("/staging/algorithms");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingAlgorithm>>(){});
    }

    public List<StagingVersion> stagingAlgorithmVersions(String algorithm) {
        WebTarget target = this.createTarget("/staging/{algorithm}/versions").resolveTemplate("algorithm", (Object)algorithm);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingVersion>>(){});
    }

    public List<StagingSchemaInfo> stagingSchemas(String algorithm, String version, String query, String site, String hist, String ssf25) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schemas").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).queryParam("q", new Object[]{query}).queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{hist}).queryParam("ssf25", new Object[]{ssf25});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingSchemaInfo>>(){});
    }

    public StagingSchema stagingSchemaById(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schema/{id}").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (StagingSchema)this.getBuilder(target).get(StagingSchema.class);
    }

    public List<StagingTable> stagingSchemaInvolvedTables(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schema/{id}/tables").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingTable>>(){});
    }

    public List<StagingTable> stagingTables(String algorithm, String version, String query) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/tables").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).queryParam("q", new Object[]{query});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingTable>>(){});
    }

    public StagingTable stagingTableById(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/table/{id}").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (StagingTable)this.getBuilder(target).get(StagingTable.class);
    }

    public List<StagingSchema> stagingTableInvolvedSchemas(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/table/{id}/schemas").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingSchema>>(){});
    }

    public StagingOutput stagingStage(String algorithm, String version, Map<String, String> input) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/stage").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version);
        return (StagingOutput)this.getBuilder(target).post(Entity.json(input), StagingOutput.class);
    }

    static {
        _DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat(_DATE_FORMAT);
        mapper.setVisibility(JsonMethod.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        _JACKSON_PROVIDER.setMapper(mapper);
    }
}

