/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.imsweb.seerapi.client.SeerApiErrorHandler;
import com.imsweb.seerapi.client.SeerApiJacksonConverter;
import com.imsweb.seerapi.client.SeerApiRequestInterceptor;
import com.imsweb.seerapi.client.disease.DiseaseService;
import com.imsweb.seerapi.client.glossary.GlossaryService;
import com.imsweb.seerapi.client.naaccr.NaaccrService;
import com.imsweb.seerapi.client.rx.RxService;
import com.imsweb.seerapi.client.siterecode.SiteRecodeService;
import com.imsweb.seerapi.client.staging.StagingService;
import com.imsweb.seerapi.client.surgery.SurgeryService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.Converter;

public final class SeerApi {
    RestAdapter _restAdapter;

    private SeerApi(String baseUrl, String apiKey) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this._restAdapter = new RestAdapter.Builder().setEndpoint(baseUrl).setConverter((Converter)new SeerApiJacksonConverter()).setRequestInterceptor((RequestInterceptor)new SeerApiRequestInterceptor(apiKey)).setErrorHandler((ErrorHandler)new SeerApiErrorHandler()).build();
    }

    public DiseaseService disease() {
        return (DiseaseService)this._restAdapter.create(DiseaseService.class);
    }

    public GlossaryService glossary() {
        return (GlossaryService)this._restAdapter.create(GlossaryService.class);
    }

    public NaaccrService naaccr() {
        return (NaaccrService)this._restAdapter.create(NaaccrService.class);
    }

    public RxService rx() {
        return (RxService)this._restAdapter.create(RxService.class);
    }

    public SiteRecodeService siteRecode() {
        return (SiteRecodeService)this._restAdapter.create(SiteRecodeService.class);
    }

    public StagingService staging() {
        return (StagingService)this._restAdapter.create(StagingService.class);
    }

    public SurgeryService surgery() {
        return (SurgeryService)this._restAdapter.create(SurgeryService.class);
    }

    public static class Builder {
        private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest";
        private static final String _ENV_URL = "SEER_API_URL";
        private static final String _ENV_API_KEY = "SEER_API_KEY";
        private String _url;
        private String _apiKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties() {
            Properties props = new Properties();
            File config = new File(System.getProperty("user.home"), ".seerapi");
            if (config.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(config);
                    props.load(in);
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            return props;
        }

        public Builder() {
            Properties props = this.getProperties();
            this._url = props.getProperty("url");
            if (this._url == null) {
                this._url = System.getenv(_ENV_URL);
            }
            if (this._url == null) {
                this._url = _SEERAPI_URL;
            }
            this._apiKey = props.getProperty("apikey");
            if (this._apiKey == null) {
                this._apiKey = System.getenv(_ENV_API_KEY);
            }
        }

        public Builder url(String url) {
            this._url = url;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this._apiKey = apiKey;
            return this;
        }

        public SeerApi connect() {
            return new SeerApi(this._url, this._apiKey);
        }
    }
}

