/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.imsweb.seerapi.client.ErrorInterceptor;
import com.imsweb.seerapi.client.disease.DiseaseService;
import com.imsweb.seerapi.client.glossary.GlossaryService;
import com.imsweb.seerapi.client.naaccr.NaaccrService;
import com.imsweb.seerapi.client.rx.RxService;
import com.imsweb.seerapi.client.siterecode.SiteRecodeService;
import com.imsweb.seerapi.client.staging.StagingService;
import com.imsweb.seerapi.client.surgery.SurgeryService;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import retrofit.Converter;
import retrofit.JacksonConverterFactory;
import retrofit.Retrofit;

public final class SeerApi {
    private Retrofit _retroFit;

    private SeerApi(String baseUrl, final String apiKey) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request request = original.newBuilder().header("Accept", "application/json").header("X-SEERAPI-Key", apiKey).method(original.method(), original.body()).build();
                return chain.proceed(request);
            }
        });
        client.interceptors().add(new ErrorInterceptor());
        this._retroFit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)SeerApi.getMapper())).client(client).build();
    }

    protected static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        mapper.setDateFormat((DateFormat)dateFormat);
        return mapper;
    }

    public DiseaseService disease() {
        return (DiseaseService)this._retroFit.create(DiseaseService.class);
    }

    public GlossaryService glossary() {
        return (GlossaryService)this._retroFit.create(GlossaryService.class);
    }

    public NaaccrService naaccr() {
        return (NaaccrService)this._retroFit.create(NaaccrService.class);
    }

    public RxService rx() {
        return (RxService)this._retroFit.create(RxService.class);
    }

    public SiteRecodeService siteRecode() {
        return (SiteRecodeService)this._retroFit.create(SiteRecodeService.class);
    }

    public StagingService staging() {
        return (StagingService)this._retroFit.create(StagingService.class);
    }

    public SurgeryService surgery() {
        return (SurgeryService)this._retroFit.create(SurgeryService.class);
    }

    public static class Builder {
        private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest/";
        private static final String _ENV_URL = "SEER_API_URL";
        private static final String _ENV_API_KEY = "SEER_API_KEY";
        private String _url;
        private String _apiKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties() {
            Properties props = new Properties();
            File config = new File(System.getProperty("user.home"), ".seerapi");
            if (config.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(config);
                    props.load(in);
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            return props;
        }

        public Builder() {
            Properties props = this.getProperties();
            this._url = props.getProperty("url");
            if (this._url == null) {
                this._url = System.getenv(_ENV_URL);
            }
            if (this._url == null) {
                this._url = _SEERAPI_URL;
            }
            this._apiKey = props.getProperty("apikey");
            if (this._apiKey == null) {
                this._apiKey = System.getenv(_ENV_API_KEY);
            }
        }

        public Builder url(String url) {
            this._url = url;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this._apiKey = apiKey;
            return this;
        }

        public SeerApi connect() {
            return new SeerApi(this._url, this._apiKey);
        }
    }
}

