/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.imsweb.seerapi.client.ErrorInterceptor;
import com.imsweb.seerapi.client.disease.DiseaseService;
import com.imsweb.seerapi.client.glossary.GlossaryService;
import com.imsweb.seerapi.client.naaccr.NaaccrService;
import com.imsweb.seerapi.client.ndc.NdcService;
import com.imsweb.seerapi.client.rx.RxService;
import com.imsweb.seerapi.client.siterecode.SiteRecodeService;
import com.imsweb.seerapi.client.staging.StagingService;
import com.imsweb.seerapi.client.surgery.SurgeryService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class SeerApi {
    private Retrofit _retrofit;

    private SeerApi(String baseUrl, String apiKey) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().header("Accept", "application/json").header("X-SEERAPI-Key", apiKey).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor((Interceptor)new ErrorInterceptor()).build();
        this._retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)SeerApi.getMapper())).client(client).build();
    }

    static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        mapper.setDateFormat((DateFormat)dateFormat);
        return mapper;
    }

    public DiseaseService disease() {
        return (DiseaseService)this._retrofit.create(DiseaseService.class);
    }

    public GlossaryService glossary() {
        return (GlossaryService)this._retrofit.create(GlossaryService.class);
    }

    public NaaccrService naaccr() {
        return (NaaccrService)this._retrofit.create(NaaccrService.class);
    }

    public NdcService ndc() {
        return (NdcService)this._retrofit.create(NdcService.class);
    }

    public RxService rx() {
        return (RxService)this._retrofit.create(RxService.class);
    }

    public SiteRecodeService siteRecode() {
        return (SiteRecodeService)this._retrofit.create(SiteRecodeService.class);
    }

    public StagingService staging() {
        return (StagingService)this._retrofit.create(StagingService.class);
    }

    public SurgeryService surgery() {
        return (SurgeryService)this._retrofit.create(SurgeryService.class);
    }

    public static class Builder {
        private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest/";
        private static final String _ENV_URL = "SEER_API_URL";
        private static final String _ENV_API_KEY = "SEER_API_KEY";
        private String _url;
        private String _apiKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties() {
            Properties props = new Properties();
            File config = new File(System.getProperty("user.home"), ".seerapi");
            if (config.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(config);
                    props.load(in);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return props;
        }

        public Builder() {
            Properties props = this.getProperties();
            this._url = props.getProperty("url");
            if (this._url == null) {
                this._url = System.getenv(_ENV_URL);
            }
            if (this._url == null) {
                this._url = _SEERAPI_URL;
            }
            this._apiKey = props.getProperty("apikey");
            if (this._apiKey == null) {
                this._apiKey = System.getenv(_ENV_API_KEY);
            }
        }

        public Builder url(String url) {
            this._url = url;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this._apiKey = apiKey;
            return this;
        }

        public SeerApi connect() {
            return new SeerApi(this._url, this._apiKey);
        }
    }
}

