/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StagingFileDataProvider
extends StagingDataProvider {
    private String _algorithm;
    private String _version;
    private Map<String, StagingTable> _tables = new HashMap<String, StagingTable>();
    private Map<String, StagingSchema> _schemas = new HashMap<String, StagingSchema>();

    protected StagingFileDataProvider(String algorithm, String version) {
        String directory;
        this._algorithm = algorithm;
        this._version = version;
        try {
            directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/tables";
            for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                if (file.isEmpty()) continue;
                StagingTable table = (StagingTable)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(directory + "/" + file + ".json")), StagingTable.class);
                StagingFileDataProvider.initTable(table);
                this._tables.put(table.getId(), table);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
        }
        try {
            directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/schemas";
            for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                if (file.isEmpty()) continue;
                StagingSchema schema = (StagingSchema)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(directory + "/" + file + ".json")), StagingSchema.class);
                StagingFileDataProvider.initSchema(schema);
                this._schemas.put(schema.getId(), schema);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
        }
        this.invalidateCache();
    }

    private static List<String> readLines(String location) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(StagingFileDataProvider.getStagingInputStream(location), StandardCharsets.UTF_8));){
            List<String> list = buffer.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static InputStream getStagingInputStream(String location) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (input == null) {
            throw new IllegalStateException("Internal error reading file; File could not be found: " + location);
        }
        return input;
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm.toLowerCase();
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        return this._tables.get(id);
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    @Override
    public Set<String> getTableIds() {
        return this._tables.keySet();
    }

    @Override
    public StagingSchema getDefinition(String id) {
        return this._schemas.get(id);
    }
}

