/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.imsweb.decisionengine.Definition;
import com.imsweb.staging.entities.StagingKeyValue;
import com.imsweb.staging.entities.StagingMapping;
import com.imsweb.staging.entities.StagingSchemaInput;
import com.imsweb.staging.entities.StagingSchemaOutput;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Property;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bson.types.ObjectId;

@JsonPropertyOrder(value={"id", "algorithm", "version", "name", "title", "subtitle", "description", "notes", "schema_num", "schema_selection_table", "schema_discriminators", "initial_context", "inputs", "outputs", "mappings", "involved_tables", "on_invalid_input", "last_modified"})
@Entity(value="staging_schemas", noClassnameStored=true)
public class StagingSchema
implements Definition {
    @Id
    private ObjectId _id;
    @Indexed
    @Property(value="id")
    private String _displayId;
    @Indexed
    @Property(value="algorithm")
    private String _algorithm;
    @Indexed
    @Property(value="version")
    private String _version;
    @Property(value="name")
    private String _name;
    @Property(value="title")
    private String _title;
    @Property(value="description")
    private String _description;
    @Property(value="subtitle")
    private String _subtitle;
    @Property(value="notes")
    private String _notes;
    @Property(value="modified")
    private Date _lastModified;
    @Property(value="schema_num")
    private Integer _schemaNum;
    @Embedded(value="schema_selection_table")
    private String _schemaSelectionTable;
    @Embedded(value="schema_discriminators")
    private Set<String> _schemaDiscriminators;
    @Embedded(value="inputs")
    private List<StagingSchemaInput> _inputs;
    @Embedded(value="outputs")
    private List<StagingSchemaOutput> _outputs;
    @Embedded(value="initial_context")
    private Set<StagingKeyValue> _initialContext;
    @Embedded(value="mappings")
    private List<StagingMapping> _mappings;
    @Property(value="involved_tables")
    private Set<String> _involvedTables;
    @Property(value="on_invalid_input")
    private Definition.StagingInputErrorHandler _onInvalidInput;
    @Embedded(value="parsed_input_map")
    private Map<String, StagingSchemaInput> _parsedInputMap = new HashMap<String, StagingSchemaInput>();
    @Embedded(value="parsed_output_map")
    private Map<String, StagingSchemaOutput> _parsedOutputMap = new HashMap<String, StagingSchemaOutput>();

    @JsonIgnore
    public ObjectId getInternalId() {
        return this._id;
    }

    public void setInternalId(ObjectId id) {
        this._id = id;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._displayId;
    }

    public void setId(String id) {
        this._displayId = id;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @JsonProperty(value="schema_num")
    public Integer getSchemaNum() {
        return this._schemaNum;
    }

    public void setSchemaNum(Integer schemaNum) {
        this._schemaNum = schemaNum;
    }

    @JsonProperty(value="schema_selection_table")
    public String getSchemaSelectionTable() {
        return this._schemaSelectionTable;
    }

    public void setSchemaSelectionTable(String schemaSelectionTable) {
        this._schemaSelectionTable = schemaSelectionTable;
    }

    @JsonProperty(value="schema_discriminators")
    public Set<String> getSchemaDiscriminators() {
        return this._schemaDiscriminators;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setSchemaDiscriminators(Set<String> schemaDiscriminators) {
        this._schemaDiscriminators = schemaDiscriminators;
    }

    @JsonProperty(value="inputs")
    public List<StagingSchemaInput> getInputs() {
        return this._inputs;
    }

    public void setInputs(List<StagingSchemaInput> inputs) {
        this._inputs = inputs;
    }

    @JsonProperty(value="outputs")
    public List<StagingSchemaOutput> getOutputs() {
        return this._outputs;
    }

    public void setOutputs(List<StagingSchemaOutput> outputs) {
        this._outputs = outputs;
    }

    @JsonProperty(value="initial_context")
    public Set<StagingKeyValue> getInitialContext() {
        return this._initialContext;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInitialContext(Set<StagingKeyValue> initialContext) {
        this._initialContext = initialContext;
    }

    @JsonProperty(value="mappings")
    public List<StagingMapping> getMappings() {
        return this._mappings;
    }

    public void setMappings(List<StagingMapping> mapping) {
        this._mappings = mapping;
    }

    @JsonIgnore
    public Map<String, StagingSchemaInput> getInputMap() {
        return this._parsedInputMap;
    }

    public void setInputMap(Map<String, StagingSchemaInput> parsedInputMap) {
        this._parsedInputMap = parsedInputMap;
    }

    @JsonIgnore
    public Map<String, StagingSchemaOutput> getOutputMap() {
        return this._parsedOutputMap;
    }

    public void setOutputMap(Map<String, StagingSchemaOutput> parsedOutputMap) {
        this._parsedOutputMap = parsedOutputMap;
    }

    @JsonProperty(value="involved_tables")
    public Set<String> getInvolvedTables() {
        return this._involvedTables;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInvolvedTables(Set<String> involvedTables) {
        this._involvedTables = involvedTables;
    }

    @Override
    @JsonProperty(value="on_invalid_input")
    public Definition.StagingInputErrorHandler getOnInvalidInput() {
        return this._onInvalidInput;
    }

    public void setOnInvalidInput(Definition.StagingInputErrorHandler onInvalidInput) {
        this._onInvalidInput = onInvalidInput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingSchema schema = (StagingSchema)o;
        return Objects.equals(this._displayId, schema._displayId) && Objects.equals(this._algorithm, schema._algorithm) && Objects.equals(this._version, schema._version) && Objects.equals(this._name, schema._name) && Objects.equals(this._title, schema._title) && Objects.equals(this._description, schema._description) && Objects.equals(this._subtitle, schema._subtitle) && Objects.equals(this._notes, schema._notes) && Objects.equals(this._schemaNum, schema._schemaNum) && Objects.equals(this._schemaSelectionTable, schema._schemaSelectionTable) && Objects.equals(this._schemaDiscriminators, schema._schemaDiscriminators) && Objects.equals(this._inputs, schema._inputs) && Objects.equals(this._outputs, schema._outputs) && Objects.equals(this._initialContext, schema._initialContext) && Objects.equals(this._mappings, schema._mappings) && Objects.equals((Object)this._onInvalidInput, (Object)schema._onInvalidInput) && Objects.equals(this._involvedTables, schema._involvedTables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._displayId, this._algorithm, this._version, this._name, this._title, this._description, this._subtitle, this._notes, this._schemaNum, this._schemaSelectionTable, this._schemaDiscriminators, this._inputs, this._outputs, this._initialContext, this._mappings, this._onInvalidInput, this._involvedTables});
    }
}

