/*
 * Decompiled with CFR 0.152.
 */
package com.indicative.client.java;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Indicative {
    private static String API_KEY = "Your-API-Key";
    private static final boolean DEBUG = false;
    private static final Logger LOG = Logger.getLogger(Indicative.class.getName());
    private static final int THREADS = 5;
    private static ExecutorService pool = Executors.newFixedThreadPool(5);
    private static final String REST_ENDPOINT_URL = "https://api.indicative.com/service/event";

    public static void apiKey(String apiKey) {
        API_KEY = apiKey;
    }

    public static Event event(String eventName) {
        return new Event(eventName);
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block13: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block13;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block13;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block13;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block13;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block13;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block13;
                }
                case '/': {
                    sb.append("\\/");
                    continue block13;
                }
                case '\u0085': {
                    sb.append("\\u0085");
                    continue block13;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block13;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block13;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block13;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static class Event {
        String apiKey;
        String eventName;
        long eventTime;
        String eventUniqueId;
        Map<String, String> properties = new HashMap<String, String>();

        protected Event(String eventName) {
            this(eventName, null);
        }

        protected Event(String eventName, String apiKey) {
            this.apiKey = apiKey == null ? API_KEY : apiKey;
            this.eventName = eventName;
            this.eventTime = System.currentTimeMillis();
        }

        public void done() {
            pool.execute(new PostThread(this));
        }

        public Event addEventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Event addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Event addProperty(String name, int value) {
            return this.addProperty(name, String.valueOf((Object)value));
        }

        public Event addProperty(String name, long value) {
            return this.addProperty(name, String.valueOf((Object)value));
        }

        public Event addProperty(String name, float value) {
            return this.addProperty(name, String.valueOf(Float.valueOf(value)));
        }

        public Event addProperty(String name, double value) {
            return this.addProperty(name, String.valueOf((Object)value));
        }

        public Event addProperty(String name, boolean value) {
            return this.addProperty(name, String.valueOf((Object)value));
        }

        public Event addProperties(Map<String, String> propertyMap) {
            if (propertyMap != null) {
                this.properties.putAll(propertyMap);
            }
            return this;
        }

        public Event uniqueId(String eventUniqueId) {
            this.eventUniqueId = eventUniqueId;
            return this;
        }

        public String toJson() {
            StringBuilder json = new StringBuilder();
            json.append("{ ");
            json.append("\"apiKey\" : \"").append(Indicative.escape(this.apiKey)).append("\", ");
            if (this.eventUniqueId != null) {
                json.append("\"eventUniqueId\" : \"").append(Indicative.escape(this.eventUniqueId)).append("\", ");
            }
            json.append("\"eventName\" : \"").append(Indicative.escape(this.eventName)).append("\", ");
            json.append("\"eventTime\" : ").append(this.eventTime).append(", ");
            json.append("\"properties\" : { ");
            if (this.properties != null) {
                Iterator<Map.Entry<String, String>> it = this.properties.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> property = it.next();
                    json.append("\"").append(Indicative.escape(property.getKey())).append("\" : \"").append(Indicative.escape(property.getValue())).append("\"");
                    if (!it.hasNext()) continue;
                    json.append(",");
                }
            }
            json.append(" }");
            json.append("}");
            return json.toString();
        }
    }

    private static class PostThread
    implements Runnable {
        Event event;

        private PostThread(Event event) {
            this.event = event;
        }

        @Override
        public void run() {
            this.sendPost(this.event.toJson());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPost(String body) {
            HttpURLConnection con = null;
            FilterOutputStream wr = null;
            try {
                URL url = new URL(Indicative.REST_ENDPOINT_URL);
                con = (HttpURLConnection)url.openConnection();
                byte[] bodyBytes = body.getBytes("UTF-8");
                con.setRequestMethod("POST");
                con.setRequestProperty("Accept-Charset", "UTF-8");
                con.addRequestProperty("Content-Type", "application/json; charset=UTF-8");
                con.setRequestProperty("Content-Length", "" + Integer.toString(bodyBytes.length));
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setInstanceFollowRedirects(false);
                con.setUseCaches(false);
                wr = new DataOutputStream(con.getOutputStream());
                wr.write(bodyBytes);
                ((DataOutputStream)wr).flush();
                wr.close();
                int responseCode = con.getResponseCode();
                if (responseCode != 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    LOG.log(Level.SEVERE, response.toString());
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            finally {
                if (con != null) {
                    try {
                        con.disconnect();
                    }
                    catch (Exception ex) {}
                }
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }
}

