/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.javaquery.spring.service.ObjectMapperService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfiguration
@ConditionalOnClass(value={ObjectMapper.class})
public class SpringUtilAutoConfiguration {
    @Bean
    @Qualifier(value="snakeCaseObjectMapper")
    @ConditionalOnMissingBean(name={"snakeCaseObjectMapper"})
    public ObjectMapper snakeCaseObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        return mapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapperService objectMapperService(ObjectMapper objectMapper, @Qualifier(value="snakeCaseObjectMapper") ObjectMapper snakeCaseObjectMapper) {
        return new ObjectMapperService(objectMapper, snakeCaseObjectMapper);
    }
}

