/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.repository;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.springframework.data.jpa.domain.Specification;

public interface AbstractSpecification<T> {
    default public Specification<T> equal(String field, Object value) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get(field), value);
    }

    default public Specification<T> notEqual(String field, Object value) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.notEqual((Expression)root.get(field), value);
    }

    default public Specification<T> in(String field, Iterable<?> ids) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> root.get(field).in(new Object[]{ids});
    }

    default public Specification<T> notIn(String field, Iterable<?> ids) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.not((Expression)root.get(field).in(new Object[]{ids}));
    }

    default public Specification<T> like(String field, String pattern) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like((Expression)root.get(field), pattern);
    }

    default public Specification<T> startsWith(String field, String prefix) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like((Expression)root.get(field), prefix + "%");
    }

    default public Specification<T> endsWith(String field, String suffix) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like((Expression)root.get(field), "%" + suffix);
    }

    default public Specification<T> contains(String field, String infix) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like((Expression)root.get(field), "%" + infix + "%");
    }
}

