/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.service;

import com.javaquery.spring.data.PageData;
import com.javaquery.spring.service.IAbstractService;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

public abstract class AbstractService<T, ID>
implements IAbstractService<T, ID> {
    protected final JpaRepository<T, ID> repository;
    protected final JpaSpecificationExecutor<T> specificationExecutor;
    protected final ApplicationEventPublisher applicationEventPublisher;

    public AbstractService(JpaRepository<T, ID> repository, ApplicationEventPublisher applicationEventPublisher) {
        this.repository = repository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.specificationExecutor = repository instanceof JpaSpecificationExecutor ? (JpaSpecificationExecutor)repository : null;
    }

    @Override
    public T save(T entity) {
        return (T)this.repository.save(entity);
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return this.repository.saveAll(entities);
    }

    @Override
    public T findById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        if (throwExceptionIfNotFound == null) {
            return this.repository.findById(id).orElse(null);
        }
        return this.repository.findById(id).orElseThrow(throwExceptionIfNotFound);
    }

    @Override
    public T deleteById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        T entity = this.findById(id, throwExceptionIfNotFound);
        if (entity != null) {
            this.repository.deleteById(id);
        }
        return entity;
    }

    @Override
    public void delete(T entity) {
        this.repository.delete(entity);
    }

    @Override
    public boolean existsById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        boolean exists = this.repository.existsById(id);
        if (!exists && throwExceptionIfNotFound != null) {
            throw throwExceptionIfNotFound.get();
        }
        return exists;
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        return this.repository.findAllById(ids);
    }

    @Override
    public PageData<T> findAll(Specification<T> specification, Pageable pageable) {
        if (this.specificationExecutor == null) {
            throw new UnsupportedOperationException("Repository does not support Specifications.");
        }
        Page page = this.specificationExecutor.findAll(specification, pageable);
        return new PageData(page.getTotalElements(), page.getTotalPages(), page.getNumber(), page.getSize(), page.getContent());
    }

    @Override
    public List<T> findAll(Specification<T> specification) {
        if (this.specificationExecutor == null) {
            throw new UnsupportedOperationException("Repository does not support Specifications.");
        }
        return this.specificationExecutor.findAll(specification);
    }

    @Override
    public PageData<T> findAll(Pageable pageable) {
        Page page = this.repository.findAll(pageable);
        return new PageData(page.getTotalElements(), page.getTotalPages(), page.getNumber(), page.getSize(), page.getContent());
    }

    @Override
    public long count() {
        return this.repository.count();
    }
}

