/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.service;

import com.javaquery.spring.data.PageData;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

public interface IAbstractService<T, ID> {
    default public T save(T entity) {
        throw new UnsupportedOperationException("Save operation is not supported.");
    }

    default public <S extends T> List<S> saveAll(Iterable<S> entities) {
        throw new UnsupportedOperationException("SaveAll operation is not supported.");
    }

    default public T findById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        throw new UnsupportedOperationException("FindById operation is not supported.");
    }

    default public T deleteById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        throw new UnsupportedOperationException("DeleteById operation is not supported.");
    }

    default public void delete(T entity) {
        throw new UnsupportedOperationException("Delete operation is not supported.");
    }

    default public boolean existsById(ID id, Supplier<? extends RuntimeException> throwExceptionIfNotFound) {
        throw new UnsupportedOperationException("ExistsById operation is not supported.");
    }

    default public List<T> findAllById(Iterable<ID> ids) {
        throw new UnsupportedOperationException("FindAllById operation is not supported.");
    }

    default public PageData<T> findAll(Specification<T> specification, Pageable pageable) {
        throw new UnsupportedOperationException("FindAll operation is not supported.");
    }

    default public List<T> findAll(Specification<T> specification) {
        throw new UnsupportedOperationException("FindAll operation is not supported.");
    }

    default public PageData<T> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("FindAll operation is not supported.");
    }

    default public long count() {
        throw new UnsupportedOperationException("Count operation is not supported.");
    }
}

