/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;

public class ObjectMapperService {
    private final ObjectMapper objectMapper;
    private final ObjectMapper snakeCaseObjectMapper;

    public ObjectMapperService(ObjectMapper objectMapper, @Qualifier(value="snakeCaseObjectMapper") ObjectMapper snakeCaseObjectMapper) {
        this.objectMapper = objectMapper;
        this.snakeCaseObjectMapper = snakeCaseObjectMapper;
    }

    public String toJson(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toSnakeCaseJson(Object obj) {
        try {
            return this.snakeCaseObjectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }

    public <T> T readValue(String string, Class<T> toValueType) {
        try {
            return (T)this.objectMapper.readValue(string, toValueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public <T> T readSnakeCaseValue(String string, Class<T> toValueType) {
        try {
            return (T)this.snakeCaseObjectMapper.readValue(string, toValueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

