/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util;

public class UniqueIdGenerator {
    private static final String PUSH_CHARS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static final int[] LAST_RAND_CHARS = new int[72];
    private static long LAST_PUSH_TIME = 0L;

    private UniqueIdGenerator() {
    }

    public static synchronized String generate() {
        int i;
        long now = System.currentTimeMillis();
        boolean duplicateTime = now == LAST_PUSH_TIME;
        LAST_PUSH_TIME = now;
        char[] timeStampChars = new char[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            timeStampChars[i2] = PUSH_CHARS.charAt((int)(now % 64L));
            now = (long)Math.floor(now / 64L);
        }
        if (now != 0L) {
            throw new AssertionError((Object)"We should have converted the entire timestamp.");
        }
        StringBuilder id = new StringBuilder(20);
        for (char c : timeStampChars) {
            id.append(c);
        }
        if (!duplicateTime) {
            for (i = 0; i < 12; ++i) {
                UniqueIdGenerator.LAST_RAND_CHARS[i] = (int)Math.floor(Double.valueOf(Math.random() * 64.0).intValue());
            }
        } else {
            for (i = 11; i >= 0 && LAST_RAND_CHARS[i] == 63; --i) {
                UniqueIdGenerator.LAST_RAND_CHARS[i] = 0;
            }
            int n = i;
            LAST_RAND_CHARS[n] = LAST_RAND_CHARS[n] + 1;
        }
        for (i = 0; i < 12; ++i) {
            id.append(PUSH_CHARS.charAt(LAST_RAND_CHARS[i]));
        }
        if (id.length() != 20) {
            throw new AssertionError((Object)"Length should be 20.");
        }
        return id.substring(1);
    }
}

