/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.collection;

import com.javaquery.util.Assert;
import com.javaquery.util.Objects;
import com.javaquery.util.collection.function.ExecutableFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Collections {
    private Collections() {
    }

    public static <T> Set<T> singleton(T o) {
        return java.util.Collections.singleton(o);
    }

    public static <T> List<T> singletonList(T o) {
        return java.util.Collections.singletonList(o);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return java.util.Collections.singletonMap(key, value);
    }

    public static <T> Set<T> emptySet() {
        return java.util.Collections.EMPTY_SET;
    }

    public static <T> List<T> emptyList() {
        return java.util.Collections.EMPTY_LIST;
    }

    public static <K, V> Map<K, V> emptyMap() {
        return java.util.Collections.EMPTY_MAP;
    }

    public static boolean nullOrEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static void nullOrEmpty(Collection<?> collection, ExecutableFunction executableFunction) {
        if (Collections.nullOrEmpty(collection)) {
            executableFunction.execute();
        }
    }

    public static boolean nonNullNonEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static void nonNullNonEmpty(Collection<?> collection, ExecutableFunction executableFunction) {
        if (Collections.nonNullNonEmpty(collection)) {
            executableFunction.execute();
        }
    }

    public static boolean nullOrEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static void nullOrEmpty(Map<?, ?> map, ExecutableFunction executableFunction) {
        if (Collections.nullOrEmpty(map)) {
            executableFunction.execute();
        }
    }

    public static boolean nonNullNonEmpty(Map<?, ?> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static void nonNullNonEmpty(Map<?, ?> map, ExecutableFunction executableFunction) {
        if (Collections.nonNullNonEmpty(map)) {
            executableFunction.execute();
        }
    }

    public static <T> Stream<List<T>> batches(List<T> source, int batchSize) {
        if (Objects.isNull(source)) {
            throw new IllegalArgumentException("source can not be null");
        }
        int size = source.size();
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize can not be negative");
        }
        if (batchSize == 0 && size != 0) {
            return Stream.of(source);
        }
        if (size <= 0) {
            return Stream.empty();
        }
        int fullChunks = (size - 1) / batchSize;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * batchSize, n == fullChunks ? size : (n + 1) * batchSize));
    }

    public static boolean isCollectionEqual(Collection<?> collectionOne, Collection<?> collectionTwo) {
        Assert.nonNull(collectionOne, NullPointerException::new);
        Assert.nonNull(collectionTwo, NullPointerException::new);
        if (collectionOne.size() != collectionTwo.size()) {
            return false;
        }
        CardinalityHelper helper = new CardinalityHelper(collectionOne, collectionTwo);
        if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
            return false;
        }
        for (Object obj : helper.cardinalityA.keySet()) {
            if (helper.freqA(obj) == helper.freqB(obj)) continue;
            return false;
        }
        return true;
    }

    public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> iterable) {
        Assert.nonNull(iterable, NullPointerException::new);
        HashMap<O, Integer> count = new HashMap<O, Integer>();
        for (O obj : iterable) {
            count.merge(obj, 1, Integer::sum);
        }
        return count;
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = Collections.getCardinalityMap(a);
            this.cardinalityB = Collections.getCardinalityMap(b);
        }

        public final int max(Object obj) {
            return Math.max(this.freqA(obj), this.freqB(obj));
        }

        public final int min(Object obj) {
            return Math.min(this.freqA(obj), this.freqB(obj));
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

