/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.io;

import com.javaquery.util.Assert;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files {
    private static final Logger LOGGER = LoggerFactory.getLogger(Files.class);
    public static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir");

    public static <T extends File> boolean createNewFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static <T extends File> boolean deleteAndCreateNewFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (file.exists()) {
            file.delete();
        }
        return Files.createNewFile(file);
    }

    public static <T extends File> void writeToFile(T file, String data) {
        Assert.nonNull(file, NullPointerException::new);
        Assert.nonNull(data, NullPointerException::new);
        if (!file.exists()) {
            Files.createNewFile(file);
        }
        try {
            java.nio.file.Files.write(Files.getPath(file), data.getBytes(), new OpenOption[0]);
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T extends File> void appendToFile(T file, String data, boolean appendNewLine) {
        Assert.nonNull(file, NullPointerException::new);
        Assert.nonNull(data, NullPointerException::new);
        if (!file.exists()) {
            Files.createNewFile(file);
        }
        data = appendNewLine ? data + "\n" : data;
        try {
            java.nio.file.Files.write(Files.getPath(file), data.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T extends File> String readFromFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (file.exists()) {
            try {
                return new String(java.nio.file.Files.readAllBytes(Files.getPath(file)));
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static <T extends File> Path getPath(T file) {
        return Paths.get(file.getAbsolutePath(), new String[0]);
    }

    /*
     * Exception decompiling
     */
    public String loadResource(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

