/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.json;

import com.javaquery.util.Objects;
import com.javaquery.util.string.Strings;
import com.javaquery.util.time.DateTimeFormat;
import com.javaquery.util.time.Dates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;

public final class JSONObject {
    private static final org.json.JSONObject EMPTY_JSON = new org.json.JSONObject("{}");
    private org.json.JSONObject ROOT;
    private Map<String, org.json.JSONObject> CACHED_OBJECT;

    public JSONObject(String json) {
        this(new org.json.JSONObject(json));
    }

    public JSONObject() {
        this(new org.json.JSONObject());
    }

    public JSONObject(org.json.JSONObject jsonObject) {
        this.ROOT = jsonObject;
        this.CACHED_OBJECT = new HashMap<String, org.json.JSONObject>();
    }

    public JSONObject put(String key, Object value) {
        this.ROOT.put(key, value);
        return this;
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optBoolean(keyPath.key, defaultValue);
    }

    public BigDecimal optBigDecimal(String key, BigDecimal defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optBigDecimal(keyPath.key, defaultValue);
    }

    public BigInteger optBigInteger(String key, BigInteger defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optBigInteger(keyPath.key, defaultValue);
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optDouble(keyPath.key, defaultValue);
    }

    public Date optDate(String key, DateTimeFormat dateTimeFormat) {
        return this.optDate(key, dateTimeFormat, new Date());
    }

    public Date optDate(String key, DateTimeFormat dateTimeFormat, Date defaultValue) {
        Date parsedDate;
        String strDate = this.optString(key);
        Date result = defaultValue;
        if (Strings.nonNullNonEmpty(strDate) && Objects.nonNull(parsedDate = Dates.parse(strDate, dateTimeFormat))) {
            result = parsedDate;
        }
        return result;
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key) {
        return this.optEnum(clazz, key, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key, E defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return (E)this.findByKey(keyPath).optEnum(clazz, keyPath.key, defaultValue);
    }

    public float optFloat(String key) {
        return this.optFloat(key, Float.NaN);
    }

    public float optFloat(String key, float defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optFloat(keyPath.key, defaultValue);
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optInt(keyPath.key, defaultValue);
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optLong(keyPath.key, defaultValue);
    }

    public Number optNumber(String key) {
        return this.optNumber(key, null);
    }

    public Number optNumber(String key, Number defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optNumber(keyPath.key, defaultValue);
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optString(keyPath.key, defaultValue);
    }

    public org.json.JSONObject optJSONObject(String key) {
        KeyPath keyPath = new KeyPath(key);
        org.json.JSONObject jsonObject = this.findByKey(keyPath);
        org.json.JSONObject result = jsonObject.optJSONObject(keyPath.key);
        if (Objects.isNull(result) && keyPath.key.contains("[") && keyPath.key.endsWith("]")) {
            result = this.arrayJSONObject(jsonObject, keyPath.key);
        }
        return result;
    }

    public JSONArray optJSONArray(String key) {
        KeyPath keyPath = new KeyPath(key);
        return this.findByKey(keyPath).optJSONArray(keyPath.key);
    }

    private org.json.JSONObject findByKey(KeyPath keyPath) {
        if (Strings.nonNullNonEmpty(keyPath.path)) {
            if (this.CACHED_OBJECT.containsKey(keyPath.path)) {
                return this.CACHED_OBJECT.get(keyPath.path);
            }
            org.json.JSONObject result = (org.json.JSONObject)this.recursion(this.ROOT, keyPath.path);
            if (Objects.nonNull(result)) {
                this.CACHED_OBJECT.put(keyPath.path, result);
            } else {
                result = EMPTY_JSON;
            }
            return result;
        }
        return this.ROOT;
    }

    private Object recursion(org.json.JSONObject jsonObject, String path) {
        if (path.contains(".")) {
            org.json.JSONObject jsonArrayValueObject;
            int dotIndex = path.indexOf(".");
            String subKey = path.substring(0, dotIndex);
            String remainingKey = path.substring(dotIndex + 1);
            if (subKey.contains("[") && subKey.endsWith("]") && Objects.nonNull(jsonArrayValueObject = this.arrayJSONObject(jsonObject, subKey))) {
                return this.recursion(jsonArrayValueObject, remainingKey);
            }
            Object object = jsonObject.opt(subKey);
            if (object instanceof org.json.JSONObject) {
                return this.recursion(jsonObject.optJSONObject(subKey), remainingKey);
            }
        } else {
            if (path.contains("[") && path.endsWith("]")) {
                return this.arrayJSONObject(jsonObject, path);
            }
            return jsonObject.optJSONObject(path);
        }
        return jsonObject;
    }

    private org.json.JSONObject arrayJSONObject(org.json.JSONObject jsonObject, String keyWithIndex) {
        if (keyWithIndex.contains("[") && keyWithIndex.endsWith("]")) {
            int startBracket = keyWithIndex.indexOf("[");
            int endBracket = keyWithIndex.indexOf("]");
            String arrayName = keyWithIndex.substring(0, startBracket);
            int arrayIndex = Integer.parseInt(keyWithIndex.substring(startBracket + 1, endBracket));
            JSONArray jsonArray = jsonObject.optJSONArray(arrayName);
            if (Objects.nonNull(jsonArray)) {
                return jsonArray.optJSONObject(arrayIndex);
            }
        }
        return null;
    }

    public void flush() {
        this.ROOT = null;
        this.CACHED_OBJECT = null;
    }

    public String toString() {
        return this.ROOT.toString();
    }

    private static class KeyPath {
        private final String key;
        private String path;

        public KeyPath(String key) {
            int dotIndex = key.lastIndexOf(".");
            if (dotIndex > 0) {
                this.key = key.substring(dotIndex + 1);
                this.path = key.substring(0, dotIndex);
            } else {
                this.key = key;
            }
        }
    }
}

