/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.utils.agent;

import com.jd.httpservice.HttpServiceContext;
import com.jd.httpservice.ResponseConverter;
import com.jd.httpservice.agent.ServiceRequest;
import com.jd.httpservice.converters.JsonResponseConverter;
import com.jd.httpservice.utils.agent.WebServiceException;
import com.jd.httpservice.utils.web.WebResponse;
import java.io.InputStream;
import utils.PrimitiveUtils;
import utils.serialize.json.JSONSerializeUtils;

public class WebResponseConverter
implements ResponseConverter {
    private JsonResponseConverter jsonConverter = new JsonResponseConverter(WebResponse.class);
    private Class<?> dataClazz;

    public WebResponseConverter(Class<?> dataClazz) {
        this.dataClazz = dataClazz;
    }

    public Object getResponse(ServiceRequest request, InputStream responseStream, HttpServiceContext serviceContext) throws Exception {
        WebResponse response = (WebResponse)this.jsonConverter.getResponse(request, responseStream, null);
        if (response == null) {
            return null;
        }
        if (response.getError() != null) {
            throw new WebServiceException(response.getError().getErrorCode(), response.getError().getErrorMessage());
        }
        if (response.getData() == null) {
            return null;
        }
        if (this.dataClazz.isAssignableFrom(response.getData().getClass())) {
            return response.getData();
        }
        if (this.dataClazz.isAssignableFrom(String.class)) {
            return response.getData().toString();
        }
        if (PrimitiveUtils.isPrimitiveType(this.dataClazz)) {
            return PrimitiveUtils.castTo((Object)response.getData(), this.dataClazz);
        }
        return JSONSerializeUtils.deserializeAs((Object)response.getData(), this.dataClazz);
    }
}

