/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.utils.web;

public class WebResponse {
    private boolean success;
    private Object data;
    private ErrorMessage error;

    private WebResponse() {
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public ErrorMessage getError() {
        return this.error;
    }

    public void setError(ErrorMessage error) {
        this.error = error;
    }

    public static WebResponse createSuccessResult(Object data) {
        WebResponse resonseResult = new WebResponse();
        resonseResult.setSuccess(true);
        resonseResult.setData(data);
        return resonseResult;
    }

    public static WebResponse createFailureResult(int code, String message) {
        ErrorMessage errorMessage = new ErrorMessage(code, message);
        return WebResponse.createFailureResult(errorMessage);
    }

    public static WebResponse createFailureResult(ErrorMessage errorMessage) {
        WebResponse resonseResult = new WebResponse();
        resonseResult.setSuccess(false);
        resonseResult.setError(errorMessage);
        return resonseResult;
    }

    public static class ErrorMessage {
        private int errorCode;
        private String errorMessage;

        public ErrorMessage() {
        }

        public ErrorMessage(int errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

