/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.service;

import com.google.gson.reflect.TypeToken;
import com.jdroid.github.Authorization;
import com.jdroid.github.client.GitHubClient;
import com.jdroid.github.client.GitHubRequest;
import com.jdroid.github.client.PagedRequest;
import com.jdroid.github.service.GitHubService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthService
extends GitHubService {
    public OAuthService() {
    }

    public OAuthService(GitHubClient client) {
        super(client);
    }

    public List<Authorization> getAuthorizations() throws IOException {
        PagedRequest request = this.createPagedRequest();
        request.setUri("/authorizations");
        request.setType(new TypeToken<List<Authorization>>(){}.getType());
        return this.getAll(request);
    }

    public Authorization getAuthorization(int id) throws IOException {
        GitHubRequest request = this.createRequest();
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id);
        request.setUri(uri);
        request.setType((Type)((Object)Authorization.class));
        return (Authorization)this.client.get(request).getBody();
    }

    public void deleteAuthorization(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }

    public Authorization createAuthorization(Authorization authorization) throws IOException {
        return (Authorization)this.client.post("/authorizations", authorization, (Type)((Object)Authorization.class));
    }

    public Authorization addScopes(int id, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id);
        Map<String, Collection<String>> params = Collections.singletonMap("add_scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params, (Type)((Object)Authorization.class));
    }

    public Authorization removeScopes(int id, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id);
        Map<String, Collection<String>> params = Collections.singletonMap("remove_scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params, (Type)((Object)Authorization.class));
    }

    public Authorization setScopes(int id, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id);
        Map<String, Collection<String>> params = Collections.singletonMap("scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params, (Type)((Object)Authorization.class));
    }
}

